/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.client.screens.widgets;

import com.mojang.math.Axis;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class MeterNeedleIndicator
extends AbstractWidget {
    double value = 0.0;
    int u;
    int v;
    int textureWidth;
    int textureHeight;
    MeterNeedleType mnt;
    int meterInnerRadius = -1;
    double startingAngle = -1.0;
    double endingAngle = -1.0;
    int meterWidth = -1;
    int meterHeight = -1;
    private ResourceLocation TEXTURE;
    private double currentNeedlePosition = 0.0;
    private double needleVelocity = 0.0;
    private long lastUpdateTime = 0L;
    private double dampingFactor = 0.85;
    private double springConstant = 0.3;
    private double maxVelocity = 0.05;
    private double minMovementThreshold = 0.001;
    private boolean enableBounce = true;
    private double bounceStrength = 0.05;

    public MeterNeedleIndicator(Component name, MeterNeedleType mnt, int meterDimension, int x, int y, int width, int height, int u, int v, ResourceLocation texture, int textureWidth, int textureHeight) {
        super(x, y, width, height, name);
        this.u = u;
        this.v = v;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.TEXTURE = texture;
        this.mnt = mnt;
        if (mnt == MeterNeedleType.METER_ROTATION) {
            throw new IllegalArgumentException("METER_ROTATION cannot be created with this constructor. Use the other constructor instead.");
        }
        if (mnt == MeterNeedleType.METER_HORIZONTAL) {
            this.meterWidth = meterDimension;
        }
        if (mnt == MeterNeedleType.METER_VERTICAL) {
            this.meterHeight = meterDimension;
        }
        this.lastUpdateTime = System.currentTimeMillis();
    }

    public MeterNeedleIndicator(Component name, int meterInnerRadius, double startingAngle, double endingAngle, int x, int y, int width, int height, int u, int v, ResourceLocation texture, int textureWidth, int textureHeight) {
        super(x, y, width, height, name);
        this.u = u;
        this.v = v;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.TEXTURE = texture;
        this.mnt = MeterNeedleType.METER_ROTATION;
        this.meterInnerRadius = meterInnerRadius;
        this.startingAngle = startingAngle;
        this.endingAngle = endingAngle;
        this.lastUpdateTime = System.currentTimeMillis();
    }

    private double getNeedlePercentage() {
        long currentTime = System.currentTimeMillis();
        if (this.lastUpdateTime == 0L) {
            this.lastUpdateTime = currentTime;
            return this.currentNeedlePosition;
        }
        double deltaTime = currentTime - this.lastUpdateTime;
        this.lastUpdateTime = currentTime;
        if (deltaTime > 100.0) {
            return this.currentNeedlePosition;
        }
        double positionDifference = this.value - this.currentNeedlePosition;
        double springForce = positionDifference * this.springConstant;
        if (this.enableBounce) {
            if (this.currentNeedlePosition > 1.0) {
                overshoot = this.currentNeedlePosition - 1.0;
                double boundaryForce = -overshoot * this.bounceStrength * 10.0;
                springForce += boundaryForce;
                this.needleVelocity = this.needleVelocity > 0.0 ? -this.needleVelocity * 0.3 : (this.needleVelocity *= 0.8);
            } else if (this.currentNeedlePosition < 0.0) {
                overshoot = -this.currentNeedlePosition;
                double boundaryForce = overshoot * this.bounceStrength * 10.0;
                springForce += boundaryForce;
                this.needleVelocity = this.needleVelocity < 0.0 ? -this.needleVelocity * 0.3 : (this.needleVelocity *= 0.8);
            }
        }
        this.needleVelocity += springForce * deltaTime * 0.001;
        this.needleVelocity *= Math.pow(this.dampingFactor, deltaTime * 0.01);
        if (Math.abs(this.needleVelocity) > this.maxVelocity) {
            this.needleVelocity = Math.signum(this.needleVelocity) * this.maxVelocity;
        }
        this.currentNeedlePosition += this.needleVelocity * deltaTime;
        if (!this.enableBounce) {
            if (this.currentNeedlePosition > 1.0) {
                this.currentNeedlePosition = 1.0;
                this.needleVelocity = 0.0;
            } else if (this.currentNeedlePosition < 0.0) {
                this.currentNeedlePosition = 0.0;
                this.needleVelocity = 0.0;
            }
        }
        double adjustedThreshold = Math.max(this.minMovementThreshold, Math.abs(this.value) * 0.01);
        if (Math.abs(positionDifference) < adjustedThreshold && Math.abs(this.needleVelocity) < this.minMovementThreshold) {
            this.needleVelocity = 0.0;
            this.currentNeedlePosition = this.value;
        }
        return this.currentNeedlePosition;
    }

    public void setValue(double targetValue) {
        this.value = Math.max(0.0, Math.min(1.0, targetValue));
    }

    public double getValue() {
        return this.value;
    }

    public void configurePhysics(double springConstant, double dampingFactor, double maxVelocity) {
        this.springConstant = Math.max(0.01, Math.min(1.0, springConstant));
        this.dampingFactor = Math.max(0.0, Math.min(1.0, dampingFactor));
        this.maxVelocity = Math.max(0.001, maxVelocity);
    }

    public void configureBounce(boolean enabled, double boundaryStiffness) {
        this.enableBounce = enabled;
        this.bounceStrength = Math.max(0.01, Math.min(2.0, boundaryStiffness));
    }

    public void snapToTarget() {
        this.currentNeedlePosition = this.value;
        this.needleVelocity = 0.0;
    }

    protected void renderWidget(@NotNull GuiGraphics guiGraphics, int i, int i1, float v) {
        double needlePos = this.getNeedlePercentage();
        double renderPos = Math.max(0.0, Math.min(1.0, needlePos));
        switch (this.mnt.ordinal()) {
            case 0: {
                int horizontalOffset = (int)(renderPos * (double)this.meterWidth);
                guiGraphics.blit(this.TEXTURE, this.getX() + horizontalOffset, this.getY(), (float)this.u, v, this.width, this.height, this.textureWidth, this.textureHeight);
                break;
            }
            case 1: {
                int verticalOffset = (int)(renderPos * (double)this.meterHeight);
                guiGraphics.blit(this.TEXTURE, this.getX(), this.getY() + verticalOffset, (float)this.u, v, this.width, this.height, this.textureWidth, this.textureHeight);
                break;
            }
            case 2: {
                double currentAngle = this.startingAngle + renderPos * (this.endingAngle - this.startingAngle);
                double angleRadians = Math.toRadians(currentAngle);
                int centerX = this.getX() + this.width / 2;
                int centerY = this.getY() + this.height / 2;
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate((float)centerX, (float)centerY, 0.0f);
                guiGraphics.pose().mulPose(Axis.ZP.rotation((float)angleRadians));
                guiGraphics.pose().translate((float)(-this.width / 2), (float)(-this.meterInnerRadius), 0.0f);
                guiGraphics.blit(this.TEXTURE, 0, 0, (float)this.u, v, this.width, this.height, this.textureWidth, this.textureHeight);
                guiGraphics.pose().popPose();
            }
        }
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput narrationElementOutput) {
    }

    public static enum MeterNeedleType {
        METER_HORIZONTAL,
        METER_VERTICAL,
        METER_ROTATION;

    }
}

