/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.client.screens.widgets;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ToggleButton
extends AbstractWidget {
    private final ResourceLocation resourceLocation;
    private final int u;
    private final int v;
    private final int textureWidth;
    private final int textureHeight;
    private final OnInteract onPress;
    public boolean isToggled;

    public ToggleButton(boolean isToggled, int x, int y, int width, int height, int u, int v, ResourceLocation texLocation, int texWidth, int texHeight, OnInteract onPress) {
        super(x, y, width, height, CommonComponents.EMPTY);
        this.textureWidth = texWidth;
        this.textureHeight = texHeight;
        this.u = u;
        this.v = v;
        this.resourceLocation = texLocation;
        this.isToggled = isToggled;
        this.onPress = onPress;
    }

    protected void renderWidget(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        int xBlit = !this.isHovered() ? this.u : this.u + this.width;
        int yBlit = !this.isToggled ? this.v : this.v + this.height;
        pGuiGraphics.blit(this.resourceLocation, this.getX(), this.getY(), (float)xBlit, (float)yBlit, this.width, this.height, this.textureWidth, this.textureHeight);
    }

    public void onClick(double x, double y, int button) {
        super.onClick(x, y, button);
        if (button == 0) {
            this.isToggled = !this.isToggled;
            this.onPress.execute(this);
        }
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput narrationElementOutput) {
        this.defaultButtonNarrationText(narrationElementOutput);
    }

    @FunctionalInterface
    public static interface OnInteract {
        public void execute(ToggleButton var1);
    }
}

