/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.client.screens.widgets;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.NotNull;

public class ValueButton
extends AbstractWidget {
    private final ResourceLocation resourceLocation;
    private final int u;
    private final int v;
    private final int textureWidth;
    private final int textureHeight;
    private final Supplier<Boolean> valueSupplier;
    private final OnInteract onPress;
    public boolean lastState = false;

    public ValueButton(int x, int y, int width, int height, int u, int v, ResourceLocation texLocation, int texWidth, int texHeight, Supplier<Boolean> valueSupplier, OnInteract onPress) {
        super(x, y, width, height, CommonComponents.EMPTY);
        this.textureWidth = texWidth;
        this.textureHeight = texHeight;
        this.u = u;
        this.v = v;
        this.resourceLocation = texLocation;
        this.valueSupplier = valueSupplier;
        this.onPress = onPress;
    }

    protected void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        boolean value = this.valueSupplier.get();
        int xBlit = !this.isHovered() ? this.u : this.u + this.width;
        int yBlit = !value ? this.v : this.v + this.height;
        pGuiGraphics.blit(this.resourceLocation, this.getX(), this.getY(), (float)xBlit, (float)yBlit, this.width, this.height, this.textureWidth, this.textureHeight);
        if (this.lastState != value) {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        }
        this.lastState = value;
    }

    public void onClick(double x, double y, int button) {
        super.onClick(x, y, button);
        if (button == 0) {
            this.onPress.execute(this);
        }
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput narrationElementOutput) {
        this.defaultButtonNarrationText(narrationElementOutput);
    }

    public void playDownSound(@NotNull SoundManager handler) {
    }

    @FunctionalInterface
    public static interface OnInteract {
        public void execute(ValueButton var1);
    }
}

