/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.be_networks;

import com.arrl.radiocraft.api.benetworks.BENetwork;
import com.arrl.radiocraft.api.benetworks.BENetworkObject;
import com.arrl.radiocraft.api.benetworks.BENetworkRegistry;
import com.arrl.radiocraft.api.capabilities.IBENetworks;
import com.arrl.radiocraft.common.blocks.WireBlock;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Pair;

public class WireUtils {
    public static void mergeNetworks(Level level, BlockPos pos, Predicate<BENetworkObject> connection, Supplier<BENetwork> fallbackSupplier, WireBlock ... wires) {
        Map<BENetworkObject, Direction> connections = WireUtils.getConnections(level, pos, connection, wires);
        if (!connections.isEmpty()) {
            HashSet<BENetwork> existingNetworks = new HashSet<BENetwork>();
            HashSet<BENetworkObject> nullItems = new HashSet<BENetworkObject>();
            for (BENetworkObject networkObject : connections.keySet()) {
                BENetwork network = networkObject.getNetwork(connections.get(networkObject));
                if (network == null) {
                    nullItems.add(networkObject);
                    continue;
                }
                existingNetworks.add(network);
            }
            BENetwork newNetwork = BENetwork.merge(existingNetworks, fallbackSupplier, level);
            for (BENetworkObject networkObject : nullItems) {
                networkObject.setNetwork(connections.get(networkObject), newNetwork);
                newNetwork.add(networkObject);
            }
        }
    }

    public static void splitNetworks(Level level, BlockPos pos, Predicate<BENetworkObject> connection, WireBlock ... wires) {
        BENetworkObject networkObject;
        Object checkPos;
        HashMap<Direction, Map<BENetworkObject, Direction>> connectionsPerSide = new HashMap<Direction, Map<BENetworkObject, Direction>>();
        Set<WireBlock> wireSet = Set.of(wires);
        HashSet<BlockPos> blacklist = new HashSet<BlockPos>();
        blacklist.add(pos);
        for (Direction dir : Direction.values()) {
            checkPos = pos.relative(dir);
            networkObject = IBENetworks.getObject(level, (BlockPos)checkPos);
            if (networkObject != null && connection.test(networkObject)) {
                connectionsPerSide.put(dir, Map.of(networkObject, dir.getOpposite()));
                continue;
            }
            if (!wireSet.contains(level.getBlockState((BlockPos)checkPos).getBlock())) continue;
            connectionsPerSide.put(dir, WireUtils.getConnections(new HashMap<BENetworkObject, Direction>(), blacklist, level, (BlockPos)checkPos, connection, wireSet));
        }
        for (Direction dir : connectionsPerSide.keySet()) {
            Map connections = (Map)connectionsPerSide.get(dir);
            BENetwork networkToReplace = null;
            checkPos = connections.keySet().iterator();
            while (checkPos.hasNext() && (networkToReplace = (networkObject = (BENetworkObject)checkPos.next()).getNetwork((Direction)connections.get(networkObject))) == null) {
            }
            if (networkToReplace == null) continue;
            BENetwork newNetwork = BENetworkRegistry.createNetwork(networkToReplace.getType(), UUID.randomUUID(), level);
            for (BENetworkObject networkObject2 : connections.keySet()) {
                networkToReplace.remove(networkObject2, true);
                networkObject2.setNetwork((Direction)connections.get(networkObject2), newNetwork);
                newNetwork.add(networkObject2);
                IBENetworks.get(level).removeNetwork(networkToReplace);
                IBENetworks.get(level).addNetwork(newNetwork);
            }
        }
    }

    public static void tryConnect(Level level, BlockPos pos, Predicate<BENetworkObject> validConnection, Supplier<BENetwork> fallbackSupplier, WireBlock ... wires) {
        BENetworkObject networkObject = IBENetworks.getObject(level, pos);
        if (networkObject == null) {
            return;
        }
        Set<WireBlock> wireSet = Set.of(wires);
        for (Direction dir : Direction.values()) {
            BlockPos checkPos = pos.relative(dir);
            if (!wireSet.contains(level.getBlockState(checkPos).getBlock())) continue;
            Pair<BENetworkObject, Direction> connection = WireUtils.getFirstConnection(level, checkPos, validConnection, wires);
            if (connection == null) {
                return;
            }
            BENetwork network = ((BENetworkObject)connection.getKey()).getNetwork((Direction)connection.getValue());
            if (network == null) {
                network = fallbackSupplier.get();
                IBENetworks.addNetwork(level, network);
                ((BENetworkObject)connection.getKey()).setNetwork((Direction)connection.getValue(), network);
                network.add((BENetworkObject)connection.getKey());
            }
            networkObject.setNetwork(dir, network);
            network.add(networkObject);
        }
    }

    public static Map<BENetworkObject, Direction> getConnections(Level level, BlockPos pos, Predicate<BENetworkObject> connection, WireBlock ... wires) {
        return WireUtils.getConnections(new HashMap<BENetworkObject, Direction>(), new HashSet<BlockPos>(), level, pos, connection, Set.of(wires));
    }

    public static Map<BENetworkObject, Direction> getConnections(Map<BENetworkObject, Direction> connections, Set<BlockPos> blackList, Level level, BlockPos pos, Predicate<BENetworkObject> connection, Set<WireBlock> wires) {
        blackList.add(pos);
        BlockState state = level.getBlockState(pos);
        if (wires.contains(state.getBlock())) {
            WireBlock wire = (WireBlock)state.getBlock();
            for (Direction dir : wire.getConnections((BlockGetter)level, pos)) {
                BlockPos checkPos = pos.relative(dir);
                if (blackList.contains(checkPos)) continue;
                BENetworkObject networkObject = IBENetworks.getObject(level, checkPos);
                if (networkObject != null && connection.test(networkObject)) {
                    connections.put(networkObject, dir.getOpposite());
                    continue;
                }
                WireUtils.getConnections(connections, blackList, level, checkPos, connection, wires);
            }
        }
        return connections;
    }

    public static Pair<BENetworkObject, Direction> getFirstConnection(Level level, BlockPos pos, Predicate<BENetworkObject> connection, WireBlock ... wires) {
        return WireUtils.getFirstConnection(new HashSet<BlockPos>(), level, pos, connection, Set.of(wires));
    }

    public static Pair<BENetworkObject, Direction> getFirstConnection(Set<BlockPos> blackList, Level level, BlockPos pos, Predicate<BENetworkObject> connection, Set<WireBlock> wires) {
        blackList.add(pos);
        BlockState state = level.getBlockState(pos);
        if (wires.contains(state.getBlock())) {
            WireBlock wire = (WireBlock)state.getBlock();
            for (Direction dir : wire.getConnections((BlockGetter)level, pos)) {
                BlockPos checkPos = pos.relative(dir);
                if (blackList.contains(checkPos)) continue;
                BENetworkObject networkObject = IBENetworks.getObject(level, checkPos);
                if (networkObject != null && connection.test(networkObject)) {
                    return Pair.of((Object)networkObject, (Object)dir.getOpposite());
                }
                Pair<BENetworkObject, Direction> next = WireUtils.getFirstConnection(blackList, level, checkPos, connection, wires);
                if (next == null) continue;
                return next;
            }
        }
        return null;
    }
}

