/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.be_networks.network_objects;

import com.arrl.radiocraft.Radiocraft;
import com.arrl.radiocraft.api.antenna.AntennaTypes;
import com.arrl.radiocraft.api.antenna.IAntennaType;
import com.arrl.radiocraft.api.benetworks.BENetwork;
import com.arrl.radiocraft.api.benetworks.BENetworkObject;
import com.arrl.radiocraft.api.capabilities.IBENetworks;
import com.arrl.radiocraft.common.be_networks.ICoaxNetworkObject;
import com.arrl.radiocraft.common.be_networks.network_objects.RadioNetworkObject;
import com.arrl.radiocraft.common.blockentities.radio.HFRadioBlockEntity;
import com.arrl.radiocraft.common.blockentities.radio.RadioBlockEntity;
import com.arrl.radiocraft.common.radio.Band;
import com.arrl.radiocraft.common.radio.antenna.AntennaCWPacket;
import com.arrl.radiocraft.common.radio.antenna.AntennaNetwork;
import com.arrl.radiocraft.common.radio.antenna.AntennaVoicePacket;
import com.arrl.radiocraft.common.radio.antenna.StaticAntenna;
import com.arrl.radiocraft.common.radio.antenna.networks.AntennaNetworkManager;
import com.arrl.radiocraft.common.radio.morse.CWBuffer;
import de.maxhenkel.voicechat.api.ServerLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;

public class AntennaNetworkObject
extends BENetworkObject
implements ICoaxNetworkObject {
    public static final ResourceLocation TYPE = Radiocraft.id("antenna");
    protected final List<RadioNetworkObject> radios = Collections.synchronizedList(new ArrayList());
    protected StaticAntenna<?> antenna = null;
    protected ResourceLocation networkId;

    public AntennaNetworkObject(Level level, BlockPos pos, ResourceLocation networkId) {
        super(level, pos);
        this.networkId = networkId;
    }

    public void transmitAudioPacket(ServerLevel level, short[] rawAudio, Band band, float frequency, UUID sourcePlayer) {
        this.antenna.transmitAudioPacket(level, rawAudio, band, frequency, sourcePlayer);
    }

    public void receiveAudioPacket(AntennaVoicePacket packet) {
        if (this.radios.size() == 1) {
            RadioBlockEntity radio;
            BlockEntity blockEntity;
            BlockPos checkPos = this.radios.get(0).getPos();
            if (this.level.isLoaded(checkPos) && (blockEntity = this.level.getChunkAt(checkPos).getBlockEntity(checkPos, LevelChunk.EntityCreationType.IMMEDIATE)) instanceof RadioBlockEntity && (radio = (RadioBlockEntity)blockEntity).getFrequency() == packet.getFrequency()) {
                radio.getVoiceReceiver().receive(packet);
            }
        } else if (this.radios.size() > 1) {
            this.overdraw(this.level);
        }
    }

    public void transmitCWPacket(net.minecraft.server.level.ServerLevel level, Collection<CWBuffer> buffers, Band band, float frequency) {
        this.antenna.transmitCWPacket(level, buffers, band, frequency);
    }

    public void receiveCWPacket(AntennaCWPacket packet) {
        if (this.radios.size() == 1) {
            HFRadioBlockEntity radio;
            BlockEntity be;
            if (this.level.isLoaded(this.pos) && (be = this.level.getBlockEntity(this.radios.get(0).getPos())) instanceof HFRadioBlockEntity && (radio = (HFRadioBlockEntity)be).getFrequency() == packet.getFrequency()) {
                radio.receiveCW(packet);
            }
        } else if (this.radios.size() > 1) {
            this.overdraw(this.level);
        }
    }

    public void overdraw(Level level) {
        for (BENetworkObject bENetworkObject : this.radios) {
            BlockEntity be;
            if (!level.isLoaded(this.pos) || !((be = level.getBlockEntity(bENetworkObject.getPos())) instanceof RadioBlockEntity)) continue;
            RadioBlockEntity radio = (RadioBlockEntity)be;
            radio.overdraw();
        }
    }

    @Override
    public void onNetworkUpdateAdd(BENetwork network, BENetworkObject object) {
        if (object instanceof RadioNetworkObject) {
            RadioNetworkObject radio = (RadioNetworkObject)object;
            this.radios.add(radio);
        }
    }

    @Override
    public void onNetworkUpdateRemove(BENetwork network, BENetworkObject object) {
        if (object instanceof RadioNetworkObject) {
            RadioNetworkObject radio = (RadioNetworkObject)object;
            this.radios.remove(radio);
        }
    }

    @Override
    public void onNetworkAdd(BENetwork network) {
        if (network.getType() == BENetwork.COAXIAL_TYPE) {
            for (BENetworkObject object : network.getNetworkObjects()) {
                if (!(object instanceof RadioNetworkObject)) continue;
                RadioNetworkObject radio = (RadioNetworkObject)object;
                this.radios.add(radio);
            }
        }
    }

    @Override
    public void onNetworkRemove(BENetwork network) {
        if (network.getType() == BENetwork.COAXIAL_TYPE) {
            for (BENetworkObject object : network.getNetworkObjects()) {
                if (!(object instanceof RadioNetworkObject)) continue;
                RadioNetworkObject radio = (RadioNetworkObject)object;
                this.radios.remove(radio);
            }
        }
    }

    public double getSWR(float frequencyHertz) {
        if (this.radios.size() > 1) {
            return 10.0;
        }
        return this.antenna == null ? 0.0 : this.antenna.getSWR(frequencyHertz);
    }

    public StaticAntenna<?> getAntenna() {
        return this.antenna;
    }

    public void setAntenna(StaticAntenna<?> antenna) {
        AntennaNetwork network = AntennaNetworkManager.getNetwork(this.networkId);
        if (this.antenna != null) {
            network.removeAntenna(this.antenna);
        }
        this.antenna = antenna;
        network.addAntenna(this.antenna);
        antenna.setNetwork(network);
    }

    @Override
    public void save(CompoundTag nbt) {
        super.save(nbt);
        if (this.antenna != null) {
            nbt.putString("antennaType", this.antenna.type.getId().toString());
            nbt.put("antennaData", (Tag)this.antenna.serializeNBT(null));
        }
        nbt.putString("networkId", this.networkId.toString());
    }

    @Override
    public void load(IBENetworks cap, CompoundTag nbt) {
        IAntennaType<?> type;
        super.load(cap, nbt);
        if (nbt.contains("antennaType") && (type = AntennaTypes.getType(ResourceLocation.fromNamespaceAndPath((String)"radiocraft", (String)nbt.getString("antennaType")))) != null) {
            this.antenna = new StaticAntenna(type, this.pos, this.level);
            this.antenna.deserializeNBT(null, nbt.getCompound("antennaData"));
        }
        this.networkId = ResourceLocation.fromNamespaceAndPath((String)"radiocraft", (String)nbt.getString("networkId"));
    }

    @Override
    public ResourceLocation getType() {
        return TYPE;
    }
}

