/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.be_networks.network_objects;

import com.arrl.radiocraft.Radiocraft;
import com.arrl.radiocraft.api.benetworks.BENetwork;
import com.arrl.radiocraft.api.benetworks.PowerBENetwork;
import com.arrl.radiocraft.api.benetworks.PowerNetworkObject;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class BatteryNetworkObject
extends PowerNetworkObject {
    public static final ResourceLocation TYPE = Radiocraft.id("battery");

    public BatteryNetworkObject(Level level, BlockPos pos, int capacity, int maxReceive, int maxExtract) {
        super(level, pos, capacity, maxReceive, maxExtract);
    }

    @Override
    public boolean isIndirectConsumer() {
        return true;
    }

    @Override
    public boolean isDirectConsumer() {
        return false;
    }

    @Override
    public void tick(Level level, BlockPos pos) {
        int toPush = Math.min(this.energyStorage.getMaxExtract(), this.energyStorage.getEnergyStored());
        int pushed = 0;
        for (BENetwork n : this.networks.values()) {
            if (n instanceof PowerBENetwork) {
                PowerBENetwork network = (PowerBENetwork)n;
                int amountPushed = network.pushPower(toPush, false, false, false);
                toPush -= amountPushed;
                pushed += amountPushed;
            }
            if (toPush > 0) continue;
            break;
        }
        this.energyStorage.setEnergy(this.energyStorage.getEnergyStored() - pushed);
    }

    @Override
    public ResourceLocation getType() {
        return TYPE;
    }
}

