/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.be_networks.network_objects;

import com.arrl.radiocraft.CommonConfig;
import com.arrl.radiocraft.Radiocraft;
import com.arrl.radiocraft.api.benetworks.BENetwork;
import com.arrl.radiocraft.api.benetworks.PowerBENetwork;
import com.arrl.radiocraft.api.benetworks.PowerNetworkObject;
import com.arrl.radiocraft.api.capabilities.IBENetworks;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class ChargeControllerNetworkObject
extends PowerNetworkObject {
    public static final ResourceLocation TYPE = Radiocraft.id("charge_controller");
    public boolean isEnabled;
    private int lastPowerTick = 0;

    public ChargeControllerNetworkObject(Level level, BlockPos pos) {
        this(level, pos, false);
    }

    public ChargeControllerNetworkObject(Level level, BlockPos pos, boolean isEnabled) {
        super(level, pos, (Integer)CommonConfig.CHARGE_CONTROLLER_TICK.get() + (Integer)CommonConfig.CHARGE_CONTROLLER_BATTERY_CHARGE.get(), (Integer)CommonConfig.CHARGE_CONTROLLER_TICK.get(), (Integer)CommonConfig.CHARGE_CONTROLLER_TICK.get());
        this.isEnabled = isEnabled;
    }

    @Override
    public boolean isIndirectConsumer() {
        return false;
    }

    @Override
    public boolean isDirectConsumer() {
        return true;
    }

    @Override
    public void tick(Level level, BlockPos pos) {
        int toPush = Math.min(this.energyStorage.getMaxExtract(), this.energyStorage.getEnergyStored());
        int pushed = 0;
        for (BENetwork n : this.networks.values()) {
            if (n instanceof PowerBENetwork) {
                PowerBENetwork network = (PowerBENetwork)n;
                int amountPushed = network.pushPower(toPush, false, true, false);
                toPush -= amountPushed;
                pushed += amountPushed;
            }
            if (toPush > 0) continue;
            break;
        }
        this.lastPowerTick = pushed;
        this.energyStorage.setEnergy(this.energyStorage.getEnergyStored() - pushed);
    }

    public int getLastPowerTick() {
        return this.lastPowerTick;
    }

    @Override
    public void save(CompoundTag nbt) {
        super.save(nbt);
        nbt.putBoolean("isEnabled", this.isEnabled);
    }

    @Override
    public void load(IBENetworks cap, CompoundTag nbt) {
        super.load(cap, nbt);
        this.isEnabled = nbt.getBoolean("isEnabled");
    }

    @Override
    public ResourceLocation getType() {
        return TYPE;
    }
}

