/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.be_networks.network_objects;

import com.arrl.radiocraft.Radiocraft;
import com.arrl.radiocraft.api.benetworks.BENetwork;
import com.arrl.radiocraft.api.benetworks.BENetworkObject;
import com.arrl.radiocraft.api.benetworks.PowerNetworkObject;
import com.arrl.radiocraft.api.capabilities.IBENetworks;
import com.arrl.radiocraft.common.be_networks.ICoaxNetworkObject;
import com.arrl.radiocraft.common.be_networks.network_objects.AntennaNetworkObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class RadioNetworkObject
extends PowerNetworkObject
implements ICoaxNetworkObject {
    public static final ResourceLocation TYPE = Radiocraft.id("radio");
    public boolean isPowered = false;
    protected final List<AntennaNetworkObject> antennas = Collections.synchronizedList(new ArrayList());
    protected boolean isTransmitting = false;
    protected int transmitUse;
    protected int receiveUse;

    public RadioNetworkObject(Level level, BlockPos pos, int transmitUse, int receiveUse) {
        super(level, pos, transmitUse, transmitUse, transmitUse);
        this.transmitUse = transmitUse;
        this.receiveUse = receiveUse;
    }

    @Override
    public boolean isIndirectConsumer() {
        return true;
    }

    @Override
    public boolean isDirectConsumer() {
        return false;
    }

    @Override
    public void tick(Level level, BlockPos pos) {
        if (this.isPowered) {
            this.isPowered = this.tryConsumeEnergy(this.isTransmitting ? this.transmitUse : this.receiveUse, false);
        }
    }

    @Override
    public void save(CompoundTag nbt) {
        super.save(nbt);
        nbt.putBoolean("isPowered", this.isPowered);
        nbt.putBoolean("isTransmitting", this.isTransmitting);
        nbt.putInt("transmitUse", this.transmitUse);
        nbt.putInt("receiveUse", this.receiveUse);
    }

    @Override
    public void load(IBENetworks cap, CompoundTag nbt) {
        super.load(cap, nbt);
        this.isPowered = nbt.getBoolean("isPowered");
        this.isTransmitting = nbt.getBoolean("isTransmitting");
        this.transmitUse = nbt.getInt("transmitUse");
        this.receiveUse = nbt.getInt("receiveUse");
    }

    public void setTransmitting(boolean value) {
        this.isTransmitting = value;
    }

    public boolean canPowerOn() {
        return this.tryConsumeEnergy(this.receiveUse, true);
    }

    @Override
    public void onNetworkUpdateAdd(BENetwork network, BENetworkObject object) {
        if (object instanceof AntennaNetworkObject) {
            AntennaNetworkObject antenna = (AntennaNetworkObject)object;
            this.antennas.add(antenna);
        }
    }

    @Override
    public void onNetworkUpdateRemove(BENetwork network, BENetworkObject object) {
        if (object instanceof AntennaNetworkObject) {
            AntennaNetworkObject antenna = (AntennaNetworkObject)object;
            this.antennas.remove(antenna);
        }
    }

    @Override
    public void onNetworkAdd(BENetwork network) {
        if (network.getType() == BENetwork.COAXIAL_TYPE) {
            for (BENetworkObject object : network.getNetworkObjects()) {
                if (!(object instanceof AntennaNetworkObject)) continue;
                AntennaNetworkObject antenna = (AntennaNetworkObject)object;
                this.antennas.add(antenna);
            }
        }
    }

    @Override
    public void onNetworkRemove(BENetwork network) {
        if (network.getType() == BENetwork.COAXIAL_TYPE) {
            for (BENetworkObject object : network.getNetworkObjects()) {
                if (!(object instanceof AntennaNetworkObject)) continue;
                AntennaNetworkObject antenna = (AntennaNetworkObject)object;
                this.antennas.remove(antenna);
            }
        }
    }

    public List<AntennaNetworkObject> getAntennas() {
        return this.antennas;
    }

    @Override
    public ResourceLocation getType() {
        return TYPE;
    }
}

