/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.blockentities;

import com.arrl.radiocraft.RadiocraftServerConfig;
import com.arrl.radiocraft.api.antenna.AntennaTypes;
import com.arrl.radiocraft.api.benetworks.BENetworkObject;
import com.arrl.radiocraft.api.benetworks.INetworkObjectProvider;
import com.arrl.radiocraft.api.capabilities.IBENetworks;
import com.arrl.radiocraft.common.be_networks.network_objects.AntennaNetworkObject;
import com.arrl.radiocraft.common.init.RadiocraftBlockEntities;
import com.arrl.radiocraft.common.radio.antenna.StaticAntenna;
import com.arrl.radiocraft.common.radio.antenna.networks.AntennaNetworkManager;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class AntennaBlockEntity
extends BlockEntity
implements INetworkObjectProvider {
    protected ResourceLocation networkId;
    private int antennaCheckCooldown = -1;

    public AntennaBlockEntity(BlockPos pos, BlockState state) {
        this(pos, state, AntennaNetworkManager.HF_ID);
    }

    public AntennaBlockEntity(BlockPos pos, BlockState state, ResourceLocation networkId) {
        super(RadiocraftBlockEntities.ANTENNA.get(), pos, state);
        this.networkId = networkId;
    }

    private void updateAntenna() {
        StaticAntenna<?> a = AntennaTypes.match(this.level, this.worldPosition);
        if (a instanceof StaticAntenna) {
            AntennaNetworkObject antenna;
            StaticAntenna<?> newAntenna = a;
            if (this.level != null && (antenna = (AntennaNetworkObject)IBENetworks.getObject(this.level, this.worldPosition)) != null) {
                antenna.setAntenna(newAntenna);
            }
        }
    }

    public void markAntennaChanged() {
        this.antennaCheckCooldown = (Integer)RadiocraftServerConfig.ANTENNA_UPDATE_DELAY.get() * 20;
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof AntennaBlockEntity) {
            AntennaBlockEntity be = (AntennaBlockEntity)t;
            if (be.antennaCheckCooldown-- == 0) {
                be.updateAntenna();
            }
        }
    }

    public void onLoad() {
        super.onLoad();
        if (!this.level.isClientSide()) {
            this.getNetworkObject(this.level, this.worldPosition);
        }
    }

    @Override
    public BENetworkObject createNetworkObject() {
        return new AntennaNetworkObject(this.level, this.worldPosition, this.networkId);
    }
}

