/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.blockentities;

import com.arrl.radiocraft.api.benetworks.BENetworkObject;
import com.arrl.radiocraft.api.benetworks.INetworkObjectProvider;
import com.arrl.radiocraft.common.be_networks.network_objects.ChargeControllerNetworkObject;
import com.arrl.radiocraft.common.blockentities.ITogglableBE;
import com.arrl.radiocraft.common.blocks.power.ChargeControllerBlock;
import com.arrl.radiocraft.common.init.RadiocraftBlockEntities;
import com.arrl.radiocraft.common.init.RadiocraftItems;
import com.arrl.radiocraft.common.menus.ChargeControllerMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChargeControllerBlockEntity
extends BlockEntity
implements ITogglableBE,
INetworkObjectProvider,
MenuProvider {
    public final ItemStackHandler inventory = new ItemStackHandler(1);
    private final ContainerData fields = new ContainerData(){

        public int get(int index) {
            if (index == 0) {
                return ((ChargeControllerNetworkObject)ChargeControllerBlockEntity.this.getNetworkObject(ChargeControllerBlockEntity.this.level, ChargeControllerBlockEntity.this.worldPosition)).getLastPowerTick();
            }
            return 0;
        }

        public void set(int index, int value) {
        }

        public int getCount() {
            return 1;
        }
    };

    public ChargeControllerBlockEntity(BlockPos pos, BlockState state) {
        super(RadiocraftBlockEntities.CHARGE_CONTROLLER.get(), pos, state);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof ChargeControllerBlockEntity) {
            ChargeControllerBlockEntity be = (ChargeControllerBlockEntity)t;
            if (!level.isClientSide && be.getPoweredOn() && be.inventory.getStackInSlot(0).getItem() == RadiocraftItems.SMALL_BATTERY.get()) {
                ItemStack itemStack = be.inventory.getStackInSlot(0);
            }
        }
    }

    @Override
    public void toggle() {
        assert (this.level != null);
        if (!this.level.isClientSide) {
            BlockState state = this.level.getBlockState(this.worldPosition);
            boolean isEnabled = (Boolean)state.getValue((Property)ChargeControllerBlock.POWERED);
            BENetworkObject bENetworkObject = this.getNetworkObject(this.level, this.worldPosition);
            if (bENetworkObject instanceof ChargeControllerNetworkObject) {
                ChargeControllerNetworkObject networkObject = (ChargeControllerNetworkObject)bENetworkObject;
                networkObject.isEnabled = !isEnabled;
            }
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue((Property)ChargeControllerBlock.POWERED, (Comparable)Boolean.valueOf(!isEnabled)));
        }
    }

    public boolean getPoweredOn() {
        return this.level != null && (Boolean)this.level.getBlockState(this.worldPosition).getValue((Property)ChargeControllerBlock.POWERED) != false;
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"container.charge_controller");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, @NotNull Inventory playerInventory, @NotNull Player player) {
        return new ChargeControllerMenu(id, playerInventory, this, this.fields);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.inventory.deserializeNBT(pRegistries, pTag.getCompound("inventory"));
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        pTag.put("inventory", (Tag)this.inventory.serializeNBT(pRegistries));
    }

    @Override
    public BENetworkObject createNetworkObject() {
        assert (this.level != null);
        return new ChargeControllerNetworkObject(this.level, this.worldPosition, (Boolean)this.level.getBlockState(this.worldPosition).getValue((Property)ChargeControllerBlock.POWERED));
    }

    public void onLoad() {
        super.onLoad();
        assert (this.level != null);
        if (!this.level.isClientSide()) {
            this.getNetworkObject(this.level, this.worldPosition);
        }
    }
}

