/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.blockentities;

import com.arrl.radiocraft.CommonConfig;
import com.arrl.radiocraft.api.benetworks.BENetworkObject;
import com.arrl.radiocraft.common.be_networks.network_objects.BatteryNetworkObject;
import com.arrl.radiocraft.common.blockentities.PowerBlockEntity;
import com.arrl.radiocraft.common.capabilities.BasicEnergyStorage;
import com.arrl.radiocraft.common.init.RadiocraftBlockEntities;
import com.arrl.radiocraft.common.menus.LargeBatteryMenu;
import com.arrl.radiocraft.common.menus.slots.IntRefSplitDataSlot;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LargeBatteryBlockEntity
extends PowerBlockEntity {
    public LargeBatteryBlockEntity(BlockPos pos, BlockState state) {
        super(RadiocraftBlockEntities.LARGE_BATTERY.get(), pos, state);
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"container.large_battery");
    }

    private Supplier<Integer> getEnergyStored() {
        try {
            return () -> ((BasicEnergyStorage)((BatteryNetworkObject)this.getNetworkObject(this.level, this.worldPosition)).getStorage()).getEnergyStored();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    private Supplier<Integer> getMaxEnergyStored() {
        try {
            return () -> ((BasicEnergyStorage)((BatteryNetworkObject)this.getNetworkObject(this.level, this.worldPosition)).getStorage()).getMaxEnergyStored();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, @NotNull Inventory playerInventory, @NotNull Player player) {
        return new LargeBatteryMenu(id, this, new IntRefSplitDataSlot(value -> {}, this.getEnergyStored()), new IntRefSplitDataSlot(value -> {}, this.getMaxEnergyStored()));
    }

    @Override
    public BENetworkObject createNetworkObject() {
        return new BatteryNetworkObject(this.level, this.worldPosition, (Integer)CommonConfig.LARGE_BATTERY_CAPACITY.get(), (Integer)CommonConfig.LARGE_BATTERY_OUTPUT.get(), (Integer)CommonConfig.LARGE_BATTERY_OUTPUT.get());
    }
}

