/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.blockentities.radio;

import com.arrl.radiocraft.api.blockentities.radio.ICWReceiver;
import com.arrl.radiocraft.api.blockentities.radio.ICWTransmitter;
import com.arrl.radiocraft.api.capabilities.IBENetworks;
import com.arrl.radiocraft.client.blockentity.RadioBlockEntityClientHandler;
import com.arrl.radiocraft.common.be_networks.network_objects.AntennaNetworkObject;
import com.arrl.radiocraft.common.be_networks.network_objects.RadioNetworkObject;
import com.arrl.radiocraft.common.blockentities.radio.RadioBlockEntity;
import com.arrl.radiocraft.common.radio.Band;
import com.arrl.radiocraft.common.radio.antenna.AntennaCWPacket;
import com.arrl.radiocraft.common.radio.morse.CWBuffer;
import com.arrl.radiocraft.common.radio.morse.CWReceiveBuffer;
import com.arrl.radiocraft.common.radio.morse.CWSendBuffer;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class HFRadioBlockEntity
extends RadioBlockEntity
implements ICWReceiver,
ICWTransmitter {
    protected boolean cwEnabled = false;
    protected CWReceiveBuffer cwReceiveBuffer;
    protected CWSendBuffer cwSendBuffer;

    public HFRadioBlockEntity(BlockEntityType<? extends HFRadioBlockEntity> type, BlockPos pos, BlockState state, Band band) {
        super(type, pos, state, band);
    }

    @Override
    public CWReceiveBuffer getCWReceiveBuffer() {
        if (this.cwReceiveBuffer == null) {
            this.cwReceiveBuffer = new CWReceiveBuffer();
        }
        return this.cwReceiveBuffer;
    }

    @Override
    public CWSendBuffer getCWSendBuffer() {
        if (this.cwSendBuffer == null) {
            this.cwSendBuffer = new CWSendBuffer((ResourceKey<Level>)this.level.dimension(), this.worldPosition);
        }
        return this.cwSendBuffer;
    }

    @Override
    public boolean canReceiveCW() {
        return this.cwEnabled;
    }

    @Override
    public void receiveCW(AntennaCWPacket packet) {
        List<AntennaNetworkObject> antennas;
        if (!this.level.isClientSide && this.getCWEnabled() && (antennas = ((RadioNetworkObject)IBENetworks.getObject(this.level, this.worldPosition)).getAntennas()).size() != 1 && antennas.size() > 1) {
            this.overdraw();
        }
    }

    public boolean getCWEnabled() {
        return this.cwEnabled;
    }

    public void setCWEnabled(boolean value) {
        if (value && this.ssbEnabled) {
            this.ssbEnabled = false;
        }
        if (this.cwEnabled != value) {
            this.cwEnabled = value;
            this.updateBlock();
            this.setChanged();
        }
    }

    @Override
    public void setSSBEnabled(boolean value) {
        if (value && this.cwEnabled) {
            this.cwEnabled = false;
        }
        super.setSSBEnabled(value);
    }

    @Override
    public void transmitMorse(Collection<CWBuffer> buffers) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            List<AntennaNetworkObject> antennas = ((RadioNetworkObject)IBENetworks.getObject(this.level, this.worldPosition)).getAntennas();
            if (antennas.size() == 1) {
                antennas.get(0).transmitCWPacket(serverLevel, buffers, this.band, this.frequency);
            } else if (antennas.size() > 1) {
                this.overdraw();
            }
        }
    }

    @Override
    protected void additionalTick() {
        if (this.level.isClientSide) {
            this.getCWSendBuffer().tick();
        }
    }

    @Override
    protected void setupSaveTag(CompoundTag nbt) {
        super.setupSaveTag(nbt);
        nbt.putBoolean("cwEnabled", this.cwEnabled);
    }

    @Override
    protected void readSaveTag(CompoundTag nbt) {
        super.readSaveTag(nbt);
        this.cwEnabled = nbt.getBoolean("cwEnabled");
    }

    @Override
    protected void setupSoundInstances() {
        super.setupSoundInstances();
        RadioBlockEntityClientHandler.startMorseSoundInstance(this);
        RadioBlockEntityClientHandler.startStaticSoundInstance(this);
    }

    @Override
    public boolean shouldPlayStatic() {
        return this.getSSBEnabled() || this.getCWEnabled();
    }
}

