/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.blockentities.radio;

import com.arrl.radiocraft.RadiocraftServerConfig;
import com.arrl.radiocraft.api.benetworks.BENetworkObject;
import com.arrl.radiocraft.api.benetworks.INetworkObjectProvider;
import com.arrl.radiocraft.api.blockentities.radio.IBEVoiceReceiver;
import com.arrl.radiocraft.api.blockentities.radio.IVoiceTransmitter;
import com.arrl.radiocraft.api.capabilities.IBENetworks;
import com.arrl.radiocraft.common.be_networks.network_objects.AntennaNetworkObject;
import com.arrl.radiocraft.common.be_networks.network_objects.RadioNetworkObject;
import com.arrl.radiocraft.common.blockentities.ITogglableBE;
import com.arrl.radiocraft.common.radio.BEVoiceReceiver;
import com.arrl.radiocraft.common.radio.Band;
import com.arrl.radiocraft.common.radio.SWRHelper;
import com.arrl.radiocraft.common.radio.VoiceTransmitters;
import de.maxhenkel.voicechat.api.ServerLevel;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class RadioBlockEntity
extends BlockEntity
implements ITogglableBE,
IVoiceTransmitter,
IBEVoiceReceiver,
INetworkObjectProvider,
MenuProvider {
    protected boolean ssbEnabled = false;
    protected boolean isPTTDown = false;
    protected Band band;
    protected float frequency;
    protected final BEVoiceReceiver voiceReceiver;
    protected double antennaSWR;
    protected boolean wasPowered;
    protected final AtomicReference<BlockPos> micPos = new AtomicReference();

    public RadioBlockEntity(BlockEntityType<? extends RadioBlockEntity> type, BlockPos pos, BlockState state, Band band) {
        super(type, pos, state);
        this.micPos.set(pos);
        this.band = band;
        this.frequency = band == null ? 0.0f : band.minFrequency();
        this.voiceReceiver = new BEVoiceReceiver(pos.getX(), pos.getY(), pos.getZ());
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof RadioBlockEntity) {
            RadioBlockEntity be = (RadioBlockEntity)t;
            RadioNetworkObject networkObject = (RadioNetworkObject)be.getNetworkObject(level, pos);
            if (networkObject != null && networkObject.isPowered) {
                boolean shouldUpdate = false;
                if (be.wasPowered != networkObject.isPowered) {
                    be.wasPowered = networkObject.isPowered;
                    shouldUpdate = true;
                }
                List<AntennaNetworkObject> antennas = networkObject.getAntennas();
                double newSWR = 0.0;
                if (antennas.size() == 1) {
                    newSWR = antennas.get(0).getSWR(be.frequency);
                } else if (antennas.size() > 1) {
                    newSWR = 10.0;
                }
                if (newSWR != be.antennaSWR) {
                    be.antennaSWR = newSWR;
                    shouldUpdate = true;
                }
                if (shouldUpdate) {
                    be.updateBlock();
                }
            }
            be.additionalTick();
        }
    }

    protected void additionalTick() {
    }

    @Override
    public void toggle() {
        BENetworkObject bENetworkObject;
        if (!this.level.isClientSide() && (bENetworkObject = this.getNetworkObject(this.level, this.worldPosition)) instanceof RadioNetworkObject) {
            RadioNetworkObject networkObject = (RadioNetworkObject)bENetworkObject;
            if (networkObject.isPowered) {
                networkObject.isPowered = false;
            } else if (networkObject.canPowerOn()) {
                networkObject.isPowered = true;
            }
            this.updateIsReceiving();
            this.updateBlock();
        }
    }

    public void overdraw() {
    }

    @Override
    public BEVoiceReceiver getVoiceReceiver() {
        return this.voiceReceiver;
    }

    public boolean getSSBEnabled() {
        return this.ssbEnabled;
    }

    public void setSSBEnabled(boolean value) {
        if (this.ssbEnabled != value) {
            this.ssbEnabled = value;
            this.updateIsReceiving();
            this.updateBlock();
            this.setChanged();
        }
    }

    public void updateIsReceiving() {
        BENetworkObject bENetworkObject;
        if (!this.level.isClientSide() && (bENetworkObject = this.getNetworkObject(this.level, this.worldPosition)) instanceof RadioNetworkObject) {
            RadioNetworkObject networkObject = (RadioNetworkObject)bENetworkObject;
            if (this.canTransmitVoice()) {
                networkObject.setTransmitting(true);
                this.getVoiceReceiver().setReceiving(false);
            } else {
                networkObject.setTransmitting(false);
                if (this.ssbEnabled) {
                    this.getVoiceReceiver().setReceiving(true);
                }
            }
        }
    }

    public float getFrequency() {
        return this.frequency;
    }

    public void setFrequency(float frequency) {
        this.frequency = frequency;
    }

    public Band getBand() {
        return this.band;
    }

    public void setBand(Band band) {
        this.band = band;
        this.updateIsReceiving();
        this.updateBlock();
    }

    public boolean isPTTDown() {
        return this.isPTTDown;
    }

    public void setPTTDown(boolean value) {
        if (this.isPTTDown != value) {
            this.isPTTDown = value;
            this.updateIsReceiving();
            this.updateBlock();
        }
    }

    public void updateFrequency(int stepCount) {
        int step = (Integer)RadiocraftServerConfig.HF_FREQUENCY_STEP.get();
        float min = this.band.minFrequency();
        float max = (this.band.maxFrequency() - this.band.minFrequency()) / (float)step * (float)step + min;
        this.frequency = Mth.clamp((float)(this.frequency + (float)(step * stepCount)), (float)min, (float)max);
        this.setChanged();
    }

    @Override
    public void acceptVoicePacket(ServerLevel level, short[] rawAudio, UUID sourcePlayer) {
        List<AntennaNetworkObject> antennas = ((RadioNetworkObject)IBENetworks.getObject(this.level, this.worldPosition)).getAntennas();
        if (antennas.size() == 1) {
            antennas.get(0).transmitAudioPacket(level, rawAudio, this.band, this.frequency, sourcePlayer);
        } else if (antennas.size() > 1) {
            this.overdraw();
        }
    }

    @Override
    public boolean canTransmitVoice() {
        BENetworkObject bENetworkObject = this.getNetworkObject(this.level, this.worldPosition);
        if (bENetworkObject instanceof RadioNetworkObject) {
            RadioNetworkObject networkObject = (RadioNetworkObject)bENetworkObject;
            return this.ssbEnabled && networkObject.isPowered && this.isPTTDown;
        }
        return false;
    }

    @Override
    public Vec3 getPos() {
        return this.micPos.get().getCenter();
    }

    public double getStaticVolume() {
        if (this.antennaSWR <= 0.01) {
            return 0.0;
        }
        return SWRHelper.getEfficiencyMultiplier(this.antennaSWR);
    }

    public boolean shouldPlayStatic() {
        return this.getSSBEnabled();
    }

    protected void setupSaveTag(CompoundTag nbt) {
        nbt.putBoolean("ssbEnabled", this.ssbEnabled);
        nbt.putString("name", this.band.name());
        nbt.putFloat("frequency", this.frequency);
        nbt.putDouble("antennaSWR", this.antennaSWR);
        nbt.putBoolean("wasPowered", this.wasPowered);
    }

    protected void readSaveTag(CompoundTag nbt) {
        this.ssbEnabled = nbt.getBoolean("ssbEnabled");
        this.band = Band.getBand(nbt.getString("name"));
        this.frequency = nbt.getFloat("frequency");
        this.antennaSWR = nbt.getDouble("antennaSWR");
        this.wasPowered = nbt.getBoolean("wasPowered");
    }

    protected void setupSoundInstances() {
    }

    public void onLoad() {
        super.onLoad();
        if (this.level.isClientSide()) {
            this.setupSoundInstances();
        } else {
            VoiceTransmitters.addListener(this.level, this);
            this.getNetworkObject(this.level, this.worldPosition);
            this.updateBlock();
        }
    }

    public void setRemoved() {
        if (!this.level.isClientSide()) {
            VoiceTransmitters.removeListener(this.level, this);
        }
        super.setRemoved();
    }

    public void onChunkUnloaded() {
        if (!this.level.isClientSide()) {
            VoiceTransmitters.removeListener(this.level, this);
        }
        super.onChunkUnloaded();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public ContainerData getDataSlots() {
        if (this.level.isClientSide) {
            return new SimpleContainerData(1);
        }
        final RadioNetworkObject networkObject = (RadioNetworkObject)IBENetworks.getObject(this.level, this.worldPosition);
        return networkObject == null ? new SimpleContainerData(1) : new ContainerData(){

            public int get(int index) {
                return networkObject.isPowered ? 1 : 0;
            }

            public void set(int index, int value) {
            }

            public int getCount() {
                return 1;
            }
        };
    }

    public boolean wasPowered() {
        return this.wasPowered;
    }

    protected void updateBlock() {
        if (this.level != null && !this.level.isClientSide) {
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, state, state, 2);
        }
    }
}

