/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.blocks;

import com.arrl.radiocraft.api.benetworks.BENetwork;
import com.arrl.radiocraft.api.benetworks.BENetworkObject;
import com.arrl.radiocraft.api.benetworks.PowerBENetwork;
import com.arrl.radiocraft.api.benetworks.PowerNetworkObject;
import com.arrl.radiocraft.api.capabilities.IBENetworks;
import com.arrl.radiocraft.common.be_networks.ICoaxNetworkObject;
import com.arrl.radiocraft.common.be_networks.WireUtils;
import com.arrl.radiocraft.common.blocks.WireBlock;
import com.arrl.radiocraft.common.init.RadiocraftBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractNetworkBlock
extends BaseEntityBlock {
    protected AbstractNetworkBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void onPlace(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean isMoving) {
        if (!level.isClientSide && oldState.getBlock() != this) {
            boolean isPower = false;
            boolean isCoax = false;
            if (isPower) {
                WireUtils.tryConnect(level, pos, no -> no instanceof PowerNetworkObject, PowerBENetwork::new, (WireBlock)((Object)RadiocraftBlocks.WIRE.get()));
            }
            if (isCoax) {
                WireUtils.tryConnect(level, pos, no -> no instanceof ICoaxNetworkObject, BENetwork::new, (WireBlock)((Object)RadiocraftBlocks.COAX_WIRE.get()));
            }
        }
    }

    public void onRemove(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        if (!level.isClientSide && newState.getBlock() != this) {
            BENetworkObject networkObject = IBENetworks.getObject(level, pos);
            if (networkObject != null) {
                networkObject.clearNetworks();
            }
            IBENetworks.removeObject(level, pos);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    private double[] getShapeDimensions(@NotNull VoxelShape shape) {
        AABB boxes = (AABB)shape.toAabbs().getFirst();
        return new double[]{boxes.minX * 16.0, boxes.minZ * 16.0, boxes.maxX * 16.0, boxes.maxZ * 16.0};
    }

    @NotNull
    protected VoxelShape rotateHorizontalPlaneDirection(@NotNull Direction modelDirection, @NotNull Direction targetDirection, @NotNull VoxelShape baseShape) {
        if (modelDirection == targetDirection) {
            return baseShape;
        }
        int rotationSteps = this.getRotationSteps(modelDirection, targetDirection);
        VoxelShape result = baseShape;
        for (int i = 0; i < rotationSteps; ++i) {
            result = this.rotateClockwise90(result);
        }
        return result;
    }

    private int getRotationSteps(Direction modelDirection, Direction targetDirection) {
        int modelIndex = this.getDirectionIndex(modelDirection);
        int targetIndex = this.getDirectionIndex(targetDirection);
        return (targetIndex - modelIndex + 4) % 4;
    }

    private int getDirectionIndex(Direction direction) {
        return switch (direction) {
            case Direction.SOUTH -> 0;
            case Direction.EAST -> 1;
            case Direction.NORTH -> 2;
            case Direction.WEST -> 3;
            default -> 0;
        };
    }

    private VoxelShape rotateClockwise90(VoxelShape shape) {
        double[] dims = this.getShapeDimensions(shape);
        double minX = dims[0];
        double minZ = dims[1];
        double maxX = dims[2];
        double maxZ = dims[3];
        double newMinZ = 16.0 - maxX;
        double newMaxZ = 16.0 - minX;
        return Block.box((double)minZ, (double)0.0, (double)newMinZ, (double)maxZ, (double)16.0, (double)newMaxZ);
    }
}

