/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.blocks;

import com.arrl.radiocraft.api.benetworks.BENetwork;
import com.arrl.radiocraft.api.benetworks.PowerBENetwork;
import com.arrl.radiocraft.api.benetworks.PowerNetworkObject;
import com.arrl.radiocraft.api.capabilities.IBENetworks;
import com.arrl.radiocraft.common.be_networks.ICoaxNetworkObject;
import com.arrl.radiocraft.common.be_networks.WireUtils;
import com.arrl.radiocraft.common.init.RadiocraftBlocks;
import com.arrl.radiocraft.common.init.RadiocraftTags;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WireBlock
extends Block
implements SimpleWaterloggedBlock {
    public final boolean isPower;
    public final boolean isWaterproof;
    public static final BooleanProperty NORTH = BooleanProperty.create((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.create((String)"east");
    public static final BooleanProperty SOUTH = BooleanProperty.create((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.create((String)"west");
    public static final BooleanProperty UP = BooleanProperty.create((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.create((String)"down");
    public static final BooleanProperty ON_GROUND = BooleanProperty.create((String)"on_ground");
    public static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)NORTH, (Object)Direction.EAST, (Object)EAST, (Object)Direction.SOUTH, (Object)SOUTH, (Object)Direction.WEST, (Object)WEST, (Object)Direction.UP, (Object)UP, (Object)Direction.DOWN, (Object)DOWN));
    private static final double SHAPE_PADDING = 3.0;
    private static final VoxelShape MIDDLE_SHAPE = WireBlock.makePaddedBox(7.0, 0.0, 7.0, 9.0, 2.0, 9.0);
    private static final HashMap<Direction, VoxelShape> SHAPES = new HashMap();

    public WireBlock(BlockBehaviour.Properties properties, boolean isPower, boolean isWaterproof) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)ON_GROUND, (Comparable)Boolean.valueOf(false)));
        this.isPower = isPower;
        this.isWaterproof = isWaterproof;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN, ON_GROUND, BlockStateProperties.WATERLOGGED});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.getBlockState((BlockGetter)context.getLevel(), context.getClickedPos());
    }

    public BlockState getBlockState(BlockGetter level, BlockPos pos) {
        BlockState state = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(pos).getType() == Fluids.WATER))).setValue((Property)ON_GROUND, (Comparable)Boolean.valueOf(this.isSturdyTop(level, pos.below())));
        for (Direction direction : Direction.values()) {
            state = (BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(WireBlock.canConnectTo(level.getBlockState(pos.relative(direction)), this.isPower)));
        }
        return state;
    }

    public Set<Direction> getConnections(BlockGetter level, BlockPos pos) {
        HashSet<Direction> out = new HashSet<Direction>();
        BlockState state = level.getBlockState(pos);
        for (Direction dir : Direction.values()) {
            if (!((Boolean)state.getValue((Property)PROPERTY_BY_DIRECTION.get(dir))).booleanValue()) continue;
            out.add(dir);
        }
        return out;
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean checkMultipleSides(Level level, BlockPos pos) {
        int count = 0;
        for (Direction dir : Direction.values()) {
            block4: {
                BlockPos checkPos;
                block3: {
                    checkPos = pos.relative(dir);
                    Block block = level.getBlockState(checkPos).getBlock();
                    if (!(block instanceof WireBlock)) break block3;
                    WireBlock wireBlock = (WireBlock)block;
                    if (wireBlock.isPower == this.isPower) break block4;
                }
                if (!this.isPower || !(IBENetworks.getObject(level, checkPos) instanceof PowerNetworkObject)) continue;
            }
            if (++count < 2) continue;
            return true;
        }
        return false;
    }

    public void onPlace(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean isMoving) {
        if (level.isClientSide) {
            return;
        }
        if (oldState.is((Block)this)) {
            return;
        }
        if (this.checkMultipleSides(level, pos)) {
            if (this.isPower) {
                WireUtils.mergeNetworks(level, pos, no -> no instanceof PowerNetworkObject, PowerBENetwork::new, (WireBlock)((Object)RadiocraftBlocks.WIRE.get()));
            } else {
                WireUtils.mergeNetworks(level, pos, no -> no instanceof ICoaxNetworkObject, BENetwork::new, (WireBlock)((Object)RadiocraftBlocks.COAX_WIRE.get()));
            }
        }
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        if (newState.is((Block)this)) {
            return;
        }
        if (level.isClientSide) {
            return;
        }
        if (this.checkMultipleSides(level, pos)) {
            if (this.isPower) {
                WireUtils.splitNetworks(level, pos, no -> no instanceof PowerNetworkObject, (WireBlock)((Object)RadiocraftBlocks.WIRE.get()));
            } else {
                WireUtils.splitNetworks(level, pos, no -> no instanceof ICoaxNetworkObject, (WireBlock)((Object)RadiocraftBlocks.COAX_WIRE.get()));
            }
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    @NotNull
    public BlockState updateShape(BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return (BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(WireBlock.canConnectTo(neighborState, this.isPower)));
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        VoxelShape result = MIDDLE_SHAPE;
        for (Map.Entry<Direction, VoxelShape> entry : SHAPES.entrySet()) {
            BooleanProperty property = PROPERTY_BY_DIRECTION.get(entry.getKey());
            if (!((Boolean)state.getValue((Property)property)).booleanValue()) continue;
            result = Shapes.or((VoxelShape)result, (VoxelShape)SHAPES.get(entry.getKey()));
        }
        return result;
    }

    private boolean isSturdyTop(BlockGetter level, BlockPos pos) {
        return level.getBlockState(pos).isFaceSturdy(level, pos, Direction.UP);
    }

    private static boolean canConnectTo(BlockState state, boolean isPower) {
        Block block = state.getBlock();
        if (block instanceof WireBlock) {
            WireBlock wire = (WireBlock)block;
            return wire.isPower == isPower;
        }
        return WireBlock.isValidConnection(state, isPower);
    }

    private static VoxelShape makePaddedBox(double x, double y, double z, double x2, double y2, double z2) {
        return Block.box((double)Math.max(x - 3.0, 0.0), (double)Math.max(y - 3.0, 0.0), (double)Math.max(z - 3.0, 0.0), (double)Math.min(x2 + 3.0, 16.0), (double)Math.min(y2 + 3.0, 16.0), (double)Math.min(z2 + 3.0, 16.0));
    }

    public static boolean isValidConnection(BlockState state, boolean isPower) {
        return isPower ? state.is(RadiocraftTags.Blocks.POWER_BLOCKS) : state.is(RadiocraftTags.Blocks.COAX_BLOCKS);
    }

    public void appendHoverText(@NotNull ItemStack stack, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (this.isPower && !this.isWaterproof) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.radiocraft.not_implemented_crafting_only"));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.radiocraft.not_implemented"));
        }
    }

    static {
        SHAPES.put(Direction.NORTH, WireBlock.makePaddedBox(7.0, 0.0, 0.0, 9.0, 2.0, 7.0));
        SHAPES.put(Direction.SOUTH, WireBlock.makePaddedBox(7.0, 0.0, 9.0, 9.0, 2.0, 16.0));
        SHAPES.put(Direction.WEST, WireBlock.makePaddedBox(0.0, 0.0, 7.0, 7.0, 2.0, 9.0));
        SHAPES.put(Direction.EAST, WireBlock.makePaddedBox(9.0, 0.0, 7.0, 16.0, 2.0, 9.0));
        SHAPES.put(Direction.UP, WireBlock.makePaddedBox(7.0, 2.0, 7.0, 9.0, 16.0, 9.0));
    }
}

