/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.blocks.antennas;

import com.arrl.radiocraft.api.benetworks.BENetworkObject;
import com.arrl.radiocraft.api.capabilities.IBENetworks;
import com.arrl.radiocraft.common.be_networks.network_objects.AntennaNetworkObject;
import com.arrl.radiocraft.common.blockentities.AntennaBlockEntity;
import com.arrl.radiocraft.common.blocks.AbstractNetworkBlock;
import com.arrl.radiocraft.common.radio.antenna.StaticAntenna;
import com.arrl.radiocraft.common.radio.antenna.networks.AntennaNetworkManager;
import com.mojang.serialization.MapCodec;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AntennaCenterBlock
extends AbstractNetworkBlock {
    public AntennaCenterBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return null;
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState pState, Level pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer, @NotNull BlockHitResult pHitResult) {
        BENetworkObject bENetworkObject;
        if (!pLevel.isClientSide && (bENetworkObject = IBENetworks.getObject(pLevel, pPos)) instanceof AntennaNetworkObject) {
            AntennaNetworkObject networkObject = (AntennaNetworkObject)bENetworkObject;
            StaticAntenna<?> antenna = networkObject.getAntenna();
            if (antenna != null) {
                pPlayer.displayClientMessage((Component)Component.literal((String)antenna.type.toString()).withStyle(ChatFormatting.GREEN), false);
            } else {
                pPlayer.displayClientMessage((Component)Component.literal((String)"No valid antenna found.").withStyle(ChatFormatting.RED), false);
            }
        }
        return super.useWithoutItem(pState, pLevel, pPos, pPlayer, pHitResult);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack pStack, @NotNull BlockState pState, Level pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHitResult) {
        BENetworkObject bENetworkObject;
        if (!pLevel.isClientSide && (bENetworkObject = IBENetworks.getObject(pLevel, pPos)) instanceof AntennaNetworkObject) {
            AntennaNetworkObject networkObject = (AntennaNetworkObject)bENetworkObject;
            StaticAntenna<?> antenna = networkObject.getAntenna();
            if (antenna != null) {
                pPlayer.displayClientMessage((Component)Component.literal((String)antenna.type.toString()).withStyle(ChatFormatting.GREEN), false);
            } else {
                pPlayer.displayClientMessage((Component)Component.literal((String)"No valid antenna found.").withStyle(ChatFormatting.RED), false);
            }
        }
        return super.useItemOn(pStack, pState, pLevel, pPos, pPlayer, pHand, pHitResult);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return !level.isClientSide ? AntennaBlockEntity::tick : super.getTicker(level, state, type);
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new AntennaBlockEntity(pos, state, AntennaNetworkManager.HF_ID);
    }
}

