/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.blocks.antennas;

import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntennaConnectorBlock
extends Block {
    public static final DirectionProperty PLACED_ON = DirectionProperty.create((String)"placed_on");
    public static final HashMap<Direction, VoxelShape> SHAPES = new HashMap();

    public AntennaConnectorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PLACED_ON});
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return SHAPES.get(state.getValue((Property)PLACED_ON));
    }

    @NotNull
    public VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return SHAPES.get(state.getValue((Property)PLACED_ON));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)PLACED_ON, (Comparable)context.getClickedFace());
    }

    public void appendHoverText(@NotNull ItemStack stack, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.radiocraft.not_implemented"));
    }

    static {
        SHAPES.put(Direction.NORTH, Block.box((double)6.0, (double)6.0, (double)8.0, (double)10.0, (double)10.0, (double)16.0));
        SHAPES.put(Direction.SOUTH, Block.box((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)8.0));
        SHAPES.put(Direction.EAST, Block.box((double)0.0, (double)6.0, (double)6.0, (double)8.0, (double)10.0, (double)10.0));
        SHAPES.put(Direction.WEST, Block.box((double)8.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0));
        SHAPES.put(Direction.UP, Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0));
        SHAPES.put(Direction.DOWN, Block.box((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0));
    }
}

