/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.blocks.antennas;

import com.arrl.radiocraft.common.blockentities.AntennaBlockEntity;
import com.arrl.radiocraft.common.blocks.antennas.BalunBlock;
import com.arrl.radiocraft.common.init.RadiocraftBlocks;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class AntennaPoleBlock
extends Block
implements SimpleWaterloggedBlock {
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), (VoxelShape[])new VoxelShape[0]);
    public static final int STABILITY_MAX_DISTANCE = 10;
    public static final IntegerProperty DISTANCE = IntegerProperty.create((String)"distance", (int)0, (int)10);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty BOTTOM = BlockStateProperties.BOTTOM;

    public AntennaPoleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DISTANCE, (Comparable)Integer.valueOf(10))).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).setValue((Property)BOTTOM, (Comparable)Boolean.FALSE));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DISTANCE, WATERLOGGED, BOTTOM});
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean canBeReplaced(@NotNull BlockState state, BlockPlaceContext context) {
        return context.getItemInHand().is(this.asItem());
    }

    @NotNull
    public BlockState updateShape(BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if (!level.isClientSide()) {
            level.scheduleTick(currentPos, (Block)this, 1);
        }
        return state;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return SHAPE;
    }

    public boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        return AntennaPoleBlock.getDistance((BlockGetter)level, pos) < 7;
    }

    public void tick(BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        int i = AntennaPoleBlock.getDistance((BlockGetter)level, pos);
        BlockState blockstate = (BlockState)((BlockState)state.setValue((Property)DISTANCE, (Comparable)Integer.valueOf(i))).setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(i == 0));
        if ((Integer)blockstate.getValue((Property)DISTANCE) == 10) {
            if ((Integer)state.getValue((Property)DISTANCE) == 10) {
                FallingBlockEntity.fall((Level)level, (BlockPos)pos, (BlockState)blockstate);
            } else {
                level.destroyBlock(pos, true);
            }
        } else if (state != blockstate) {
            level.setBlock(pos, blockstate, 3);
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockpos = context.getClickedPos();
        Level level = context.getLevel();
        int i = AntennaPoleBlock.getDistance((BlockGetter)level, blockpos);
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(blockpos).getType() == Fluids.WATER))).setValue((Property)DISTANCE, (Comparable)Integer.valueOf(i))).setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(i == 0));
    }

    public static int getDistance(BlockGetter level, BlockPos pos) {
        BlockPos.MutableBlockPos mutablePos = pos.mutable().move(Direction.DOWN);
        BlockState state = level.getBlockState((BlockPos)mutablePos);
        int i = 10;
        if (state.is((Block)RadiocraftBlocks.ANTENNA_POLE.get())) {
            i = Math.min(i, (Integer)state.getValue((Property)DISTANCE) + 1);
        } else if (state.isFaceSturdy(level, (BlockPos)mutablePos, Direction.UP) || state.getBlock() instanceof BalunBlock) {
            return 0;
        }
        return i;
    }

    public void onPlace(@NotNull BlockState state, @NotNull Level level, BlockPos pos, @NotNull BlockState oldState, boolean isMoving) {
        BlockPos.MutableBlockPos bottomPos = pos.mutable().move(Direction.DOWN);
        for (int i = 0; i < 10; ++i) {
            if (level.getBlockState((BlockPos)bottomPos).getBlock() != RadiocraftBlocks.ANTENNA_POLE.get()) {
                BlockEntity blockEntity = level.getBlockEntity((BlockPos)bottomPos);
                if (blockEntity instanceof AntennaBlockEntity) {
                    AntennaBlockEntity be = (AntennaBlockEntity)blockEntity;
                    be.markAntennaChanged();
                }
                return;
            }
            bottomPos.move(Direction.DOWN);
        }
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level level, BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        BlockPos.MutableBlockPos bottomPos = pos.mutable().move(Direction.DOWN);
        for (int i = 0; i < 10; ++i) {
            if (level.getBlockState((BlockPos)bottomPos).getBlock() != RadiocraftBlocks.ANTENNA_POLE.get()) {
                BlockEntity blockEntity = level.getBlockEntity((BlockPos)bottomPos);
                if (blockEntity instanceof AntennaBlockEntity) {
                    AntennaBlockEntity be = (AntennaBlockEntity)blockEntity;
                    be.markAntennaChanged();
                }
                return;
            }
            bottomPos.move(Direction.DOWN);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public void appendHoverText(@NotNull ItemStack stack, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.radiocraft.not_implemented"));
    }
}

