/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.capabilities;

import com.arrl.radiocraft.api.benetworks.BENetwork;
import com.arrl.radiocraft.api.benetworks.BENetworkObject;
import com.arrl.radiocraft.api.capabilities.IBENetworks;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnknownNullability;

public class BENetworksCapability
implements IBENetworks {
    private final Map<BlockPos, BENetworkObject> networkObjects = new HashMap<BlockPos, BENetworkObject>();
    private final Map<UUID, BENetwork> networks = new HashMap<UUID, BENetwork>();

    @Override
    public BENetworkObject getObject(@NotNull BlockPos pos) {
        return this.networkObjects.get(pos);
    }

    @Override
    public void setObject(@NotNull BlockPos pos, @NotNull BENetworkObject object) {
        this.networkObjects.put(pos, object);
    }

    @Override
    public void removeObject(@NotNull BlockPos pos) {
        BENetworkObject obj = this.getObject(pos);
        if (obj != null) {
            obj.discard();
        }
        this.networkObjects.remove(pos);
    }

    @Override
    public BENetwork getNetwork(UUID uuid) {
        return this.networks.get(uuid);
    }

    @Override
    public void addNetwork(BENetwork network) {
        this.networks.put(network.getUUID(), network);
    }

    @Override
    public void removeNetwork(BENetwork network) {
        this.networks.remove(network.getUUID());
    }

    @Override
    public void tickNetworkObjects(Level level) {
        for (Map.Entry<BlockPos, BENetworkObject> entry : this.networkObjects.entrySet()) {
            entry.getValue().tick(level, entry.getKey());
        }
    }

    public @UnknownNullability CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        CompoundTag networks = new CompoundTag();
        for (Map.Entry<UUID, BENetwork> entry : this.networks.entrySet()) {
            if (entry.getValue().getNetworkObjects().isEmpty()) continue;
            networks.putString(entry.getKey().toString(), entry.getValue().getType().toString());
        }
        ListTag objects = new ListTag();
        for (Map.Entry<BlockPos, BENetworkObject> entry : this.networkObjects.entrySet()) {
            CompoundTag nbtEntry = new CompoundTag();
            nbtEntry.putLong("pos", entry.getKey().asLong());
            nbtEntry.putString("type", entry.getValue().getType().toString());
            entry.getValue().save(nbtEntry);
            objects.add((Object)nbtEntry);
        }
        nbt.put("networks", (Tag)networks);
        nbt.put("networkObjects", (Tag)objects);
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        CompoundTag networksTag = nbt.getCompound("networks");
        for (String key : networksTag.getAllKeys()) {
            UUID uUID = UUID.fromString(key);
        }
        ListTag objectsTag = nbt.getList("networkObjects", 10);
        for (Tag t : objectsTag) {
            CompoundTag compoundTag = (CompoundTag)t;
        }
    }
}

