/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.capabilities;

import com.arrl.radiocraft.api.capabilities.IVHFHandheldCapability;
import com.arrl.radiocraft.common.datacomponents.HandheldRadioState;
import com.arrl.radiocraft.common.init.RadiocraftDataComponent;
import com.arrl.radiocraft.common.radio.Band;
import java.util.function.UnaryOperator;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;

public class VHFHandheldCapability
implements IVHFHandheldCapability {
    private ItemStack installedBattery = ItemStack.EMPTY;
    private final ItemStack thisRadio;

    public VHFHandheldCapability(ItemStack thisRadio) {
        this.thisRadio = thisRadio;
    }

    public static IVHFHandheldCapability getCapability(ItemStack radioItemstack) {
        return new VHFHandheldCapability(radioItemstack);
    }

    @Override
    public ItemStack getBattery() {
        return this.installedBattery;
    }

    @Override
    public void setBattery(ItemStack item) {
        this.installedBattery = item;
    }

    @Override
    public float getFrequencyHertz() {
        return this.getState().freq();
    }

    @Override
    public void setFrequencyHertz(float frequencyHertz) {
        this.updateState(old -> new HandheldRadioState(old.power(), old.ptt(), Math.max(Math.min(frequencyHertz, Band.getBand(2).maxFrequency()), Band.getBand(2).minFrequency()), old.gain(), old.micGain(), old.receiveIndicatorStrength()));
    }

    @Override
    public boolean isPowered() {
        return this.getState().power();
    }

    @Override
    public void setPowered(boolean value) {
        this.updateState(old -> new HandheldRadioState(value, old.ptt(), old.freq(), old.gain(), old.micGain(), old.receiveIndicatorStrength()));
    }

    @Override
    public boolean isPTTDown() {
        return this.getState().ptt();
    }

    @Override
    public void setPTTDown(boolean value) {
        this.updateState(old -> new HandheldRadioState(old.power(), value, old.freq(), old.gain(), old.micGain(), old.receiveIndicatorStrength()));
    }

    @Override
    public void setReceiveStrength(float rec) {
        this.updateState(old -> new HandheldRadioState(old.power(), old.ptt(), old.freq(), old.gain(), old.micGain(), rec));
    }

    @Override
    public float getReceiveStrength() {
        return this.getState().receiveIndicatorStrength();
    }

    @Override
    public float getGain() {
        return this.getState().gain();
    }

    @Override
    public void setGain(float gain) {
        this.updateState(old -> new HandheldRadioState(old.power(), old.ptt(), old.freq(), gain, old.micGain(), old.receiveIndicatorStrength()));
    }

    @Override
    public float getMicGain() {
        return this.getState().micGain();
    }

    @Override
    public void setMicGain(float micGain) {
        this.updateState(old -> new HandheldRadioState(old.power(), old.ptt(), old.freq(), old.gain(), micGain, old.receiveIndicatorStrength()));
    }

    protected HandheldRadioState getState() {
        return (HandheldRadioState)this.thisRadio.getOrDefault((DataComponentType)RadiocraftDataComponent.HANDHELD_RADIO_STATE_COMPONENT.value(), (Object)HandheldRadioState.getDefault());
    }

    protected void updateState(UnaryOperator<HandheldRadioState> updater) {
        this.thisRadio.update((DataComponentType)RadiocraftDataComponent.HANDHELD_RADIO_STATE_COMPONENT.value(), (Object)HandheldRadioState.getDefault(), updater);
    }
}

