/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.commands;

import com.arrl.radiocraft.Radiocraft;
import com.arrl.radiocraft.RadiocraftServerConfig;
import com.arrl.radiocraft.api.capabilities.BlockEntityCallsignData;
import com.arrl.radiocraft.api.capabilities.LicenseClass;
import com.arrl.radiocraft.api.capabilities.PlayerCallsignData;
import com.arrl.radiocraft.common.data.BlockEntityCallsignSavedData;
import com.arrl.radiocraft.common.data.PlayerCallsignSavedData;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.server.command.EnumArgument;
import org.jetbrains.annotations.NotNull;

public class CallsignCommands {
    private static PlayerCallsignSavedData playerSavedData;
    private static BlockEntityCallsignSavedData blockEntitySavedData;
    public static final LiteralArgumentBuilder<CommandSourceStack> BUILDER;

    private static PlayerCallsignSavedData getPlayerCallsignSavedData(Level level) {
        if (playerSavedData == null) {
            MinecraftServer server = level.getServer();
            if (server != null) {
                playerSavedData = PlayerCallsignSavedData.get(level.getServer().overworld());
            } else {
                throw new IllegalStateException("Cannot get PlayerCallsignSavedData if the server is null");
            }
        }
        return playerSavedData;
    }

    private static BlockEntityCallsignSavedData getBlockEntityCallsignSavedData(Level level) {
        if (blockEntitySavedData == null) {
            MinecraftServer server = level.getServer();
            if (server != null) {
                blockEntitySavedData = BlockEntityCallsignSavedData.get(level.getServer().overworld());
            } else {
                throw new IllegalStateException("Cannot get BlockEntityCallsignSavedData if the server is null");
            }
        }
        return blockEntitySavedData;
    }

    public static int listCallsigns(CommandSourceStack source) {
        playerSavedData = CallsignCommands.getPlayerCallsignSavedData((Level)source.getLevel());
        blockEntitySavedData = CallsignCommands.getBlockEntityCallsignSavedData((Level)source.getLevel());
        HashSet<String> callsigns = new HashSet<String>(playerSavedData.getCallsigns());
        callsigns.addAll(blockEntitySavedData.getCallsigns());
        if (callsigns.isEmpty()) {
            Supplier<Component> output = () -> Component.translatable((String)Radiocraft.translationKey("commands", "callsign.list.empty"));
            source.sendSuccess(output, true);
            return 1;
        }
        Supplier<Component> output = () -> Component.literal((String)String.join((CharSequence)", ", callsigns));
        source.sendSuccess(output, true);
        return 1;
    }

    public static int getCallsign(CommandSourceStack source, String search) throws CommandSyntaxException {
        Record data;
        ServerPlayer result = source.getServer().getPlayerList().getPlayers().stream().filter(player -> player.getGameProfile().getName().toLowerCase().contains(search.toLowerCase())).findFirst().orElse(null);
        playerSavedData = CallsignCommands.getPlayerCallsignSavedData((Level)source.getLevel());
        if (result != null) {
            PlayerCallsignData data2 = playerSavedData.getCallsignData(result.getGameProfile().getId());
            MutableComponent name = Component.literal((String)result.getGameProfile().getName());
            if (data2 != null) {
                MutableComponent callsign = Component.literal((String)data2.callsign());
                MutableComponent license = Component.translatable((String)Radiocraft.translationKey("license_class", data2.licenseClass().name()));
                Supplier<Component> combined = () -> CallsignCommands.lambda$getCallsign$8((Component)name, (Component)callsign, (Component)license);
                source.sendSuccess(combined, true);
            }
            return 1;
        }
        if (playerSavedData.getCallsigns().contains(search) && (data = playerSavedData.getCallsignData(search)) != null) {
            ServerPlayer player2 = source.getServer().getPlayerList().getPlayer(UUID.fromString(((PlayerCallsignData)data).playerUUID()));
            MutableComponent name = Component.literal((String)((PlayerCallsignData)data).playerUUID());
            if (((PlayerCallsignData)data).playerName() != null && !((PlayerCallsignData)data).playerName().isEmpty()) {
                name = Component.literal((String)((PlayerCallsignData)data).playerName());
            }
            if (player2 != null) {
                name = Component.literal((String)player2.getGameProfile().getName());
            }
            MutableComponent finalName = name;
            MutableComponent callsign = Component.literal((String)((PlayerCallsignData)data).callsign());
            MutableComponent license = Component.translatable((String)Radiocraft.translationKey("license_class", ((PlayerCallsignData)data).licenseClass().name()));
            Supplier<Component> combined = () -> CallsignCommands.lambda$getCallsign$9((Component)finalName, (Component)callsign, (Component)license);
            source.sendSuccess(combined, true);
            return 1;
        }
        if (blockEntitySavedData.getCallsigns().contains(search) && (data = blockEntitySavedData.getCallsignData(search)) != null) {
            MutableComponent name = Component.literal((String)((BlockEntityCallsignData)data).pos().toString());
            MutableComponent callsign = Component.literal((String)((BlockEntityCallsignData)data).callsign());
            MutableComponent license = Component.translatable((String)Radiocraft.translationKey("license_class", ((BlockEntityCallsignData)data).licenseClass().name()));
            Supplier<Component> combined = () -> CallsignCommands.lambda$getCallsign$10((Component)name, (Component)callsign, (Component)license);
            source.sendSuccess(combined, true);
            return 1;
        }
        Supplier<Component> combined = () -> Component.translatable((String)Radiocraft.translationKey("commands", "callsign.get.failure"), (Object[])new Object[]{search});
        source.sendSuccess(combined, true);
        return 1;
    }

    public static int getPlayerCallsign(CommandSourceStack source, Collection<GameProfile> gameProfiles) throws CommandSyntaxException {
        if (gameProfiles != null && gameProfiles.size() > 1) {
            source.sendFailure((Component)Component.translatable((String)Radiocraft.translationKey("commands", "callsign.get.failure.multiple")));
            return 0;
        }
        GameProfile targetProfile = CallsignCommands.getTarget(source, gameProfiles);
        playerSavedData = CallsignCommands.getPlayerCallsignSavedData((Level)source.getLevel());
        PlayerCallsignData data = playerSavedData.getCallsignData(targetProfile.getId());
        MutableComponent name = Component.literal((String)targetProfile.getName());
        if (data != null) {
            MutableComponent callsign = Component.literal((String)data.callsign());
            MutableComponent license = Component.translatable((String)Radiocraft.translationKey("license_class", data.licenseClass().name()));
            Supplier<Component> combined = () -> CallsignCommands.lambda$getPlayerCallsign$12((Component)name, (Component)callsign, (Component)license);
            source.sendSuccess(combined, true);
        } else {
            Supplier<Component> combined = () -> CallsignCommands.lambda$getPlayerCallsign$13((Component)name);
            source.sendSuccess(combined, true);
        }
        return 1;
    }

    public static int resetCallsign(CommandSourceStack source, Collection<GameProfile> gameProfiles) throws CommandSyntaxException {
        if (gameProfiles.size() > 1) {
            source.sendFailure((Component)Component.translatable((String)Radiocraft.translationKey("commands", "callsign.reset.failure.multiple")));
            return 0;
        }
        if (((Boolean)RadiocraftServerConfig.CALLSIGN_PERMISSIONS_ENABLED.get()).booleanValue() && !CallsignCommands.isPrivileged(source.getPlayerOrException())) {
            source.sendFailure((Component)Component.translatable((String)Radiocraft.translationKey("commands", "callsign.reset.failure.permission")));
            return 0;
        }
        GameProfile targetProfile = CallsignCommands.getTarget(source, gameProfiles);
        playerSavedData = CallsignCommands.getPlayerCallsignSavedData((Level)source.getLevel());
        playerSavedData.resetCallsign(targetProfile.getId());
        MutableComponent name = Component.literal((String)targetProfile.getName());
        Supplier<Component> combined = () -> CallsignCommands.lambda$resetCallsign$14((Component)name);
        source.sendSuccess(combined, true);
        return 1;
    }

    public static int setCallsign(CommandSourceStack source, Collection<GameProfile> gameProfiles, String callsign, LicenseClass licenseClass) throws CommandSyntaxException {
        if (gameProfiles != null && gameProfiles.size() > 1) {
            source.sendFailure((Component)Component.translatable((String)Radiocraft.translationKey("commands", "callsign.set.failure.multiple")));
            return 0;
        }
        if (((Boolean)RadiocraftServerConfig.CALLSIGN_PERMISSIONS_ENABLED.get()).booleanValue() && !CallsignCommands.isPrivileged(source.getPlayerOrException())) {
            source.sendFailure((Component)Component.translatable((String)Radiocraft.translationKey("commands", "callsign.set.failure.permission")));
            return 0;
        }
        GameProfile targetProfile = CallsignCommands.getTarget(source, gameProfiles);
        playerSavedData = CallsignCommands.getPlayerCallsignSavedData((Level)source.getLevel());
        playerSavedData.setCallsignData(targetProfile.getId(), new PlayerCallsignData(targetProfile.getId().toString(), targetProfile.getName(), callsign, licenseClass));
        MutableComponent name = Component.literal((String)targetProfile.getName());
        MutableComponent license = Component.translatable((String)Radiocraft.translationKey("license_class", licenseClass.name()));
        Supplier<Component> combined = () -> CallsignCommands.lambda$setCallsign$15((Component)name, callsign, (Component)license);
        source.sendSuccess(combined, true);
        return 1;
    }

    public static GameProfile getTarget(CommandSourceStack source, Collection<GameProfile> gameProfiles) throws CommandSyntaxException {
        return gameProfiles == null || gameProfiles.isEmpty() ? source.getPlayerOrException().getGameProfile() : gameProfiles.stream().findFirst().get();
    }

    private static boolean isPrivileged(@NotNull ServerPlayer player) {
        if (player.serverLevel().getServer().isSingleplayer()) {
            return true;
        }
        return player.hasPermissions(3);
    }

    private static /* synthetic */ Component lambda$setCallsign$15(Component name, String callsign, Component license) {
        return Component.translatable((String)Radiocraft.translationKey("commands", "callsign.set.success"), (Object[])new Object[]{name, callsign, license});
    }

    private static /* synthetic */ Component lambda$resetCallsign$14(Component name) {
        return Component.translatable((String)Radiocraft.translationKey("commands", "callsign.reset.success"), (Object[])new Object[]{name});
    }

    private static /* synthetic */ Component lambda$getPlayerCallsign$13(Component name) {
        return Component.translatable((String)Radiocraft.translationKey("commands", "callsign.get.failure"), (Object[])new Object[]{name});
    }

    private static /* synthetic */ Component lambda$getPlayerCallsign$12(Component name, Component callsign, Component license) {
        return Component.translatable((String)Radiocraft.translationKey("commands", "callsign.get.success"), (Object[])new Object[]{name, callsign, license});
    }

    private static /* synthetic */ Component lambda$getCallsign$10(Component name, Component callsign, Component license) {
        return Component.translatable((String)Radiocraft.translationKey("commands", "callsign.get.success"), (Object[])new Object[]{name, callsign, license});
    }

    private static /* synthetic */ Component lambda$getCallsign$9(Component finalName, Component callsign, Component license) {
        return Component.translatable((String)Radiocraft.translationKey("commands", "callsign.get.success"), (Object[])new Object[]{finalName, callsign, license});
    }

    private static /* synthetic */ Component lambda$getCallsign$8(Component name, Component callsign, Component license) {
        return Component.translatable((String)Radiocraft.translationKey("commands", "callsign.get.success"), (Object[])new Object[]{name, callsign, license});
    }

    static {
        BUILDER = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"callsign").then(Commands.literal((String)"list").executes(command -> CallsignCommands.listCallsigns((CommandSourceStack)command.getSource())))).then(Commands.literal((String)"search").then(Commands.argument((String)"callsign", (ArgumentType)StringArgumentType.string()).executes(command -> CallsignCommands.getCallsign((CommandSourceStack)command.getSource(), StringArgumentType.getString((CommandContext)command, (String)"callsign")))))).then(Commands.literal((String)"reset").then(Commands.argument((String)"player", (ArgumentType)GameProfileArgument.gameProfile()).executes(command -> CallsignCommands.resetCallsign((CommandSourceStack)command.getSource(), GameProfileArgument.getGameProfiles((CommandContext)command, (String)"player")))))).then(Commands.literal((String)"set").then(Commands.argument((String)"player", (ArgumentType)GameProfileArgument.gameProfile()).then(Commands.argument((String)"callsign", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"license", (ArgumentType)EnumArgument.enumArgument(LicenseClass.class)).executes(command -> CallsignCommands.setCallsign((CommandSourceStack)command.getSource(), GameProfileArgument.getGameProfiles((CommandContext)command, (String)"player"), StringArgumentType.getString((CommandContext)command, (String)"callsign"), (LicenseClass)((Object)((Object)command.getArgument("license", LicenseClass.class)))))))))).then(Commands.literal((String)"get").then(Commands.argument((String)"player", (ArgumentType)GameProfileArgument.gameProfile()).executes(command -> CallsignCommands.getPlayerCallsign((CommandSourceStack)command.getSource(), GameProfileArgument.getGameProfiles((CommandContext)command, (String)"player")))));
    }
}

