/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.data;

import com.arrl.radiocraft.Radiocraft;
import com.arrl.radiocraft.api.capabilities.BlockEntityCallsignData;
import com.arrl.radiocraft.api.capabilities.IBlockEntityCallsignCapability;
import com.arrl.radiocraft.api.capabilities.LicenseClass;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class BlockEntityCallsignSavedData
extends SavedData
implements IBlockEntityCallsignCapability {
    private static final String DATA_NAME = "radiocraft_block_entity_callsign_data";
    private static final HashMap<GlobalPos, BlockEntityCallsignData> callsigns = new HashMap();

    public static BlockEntityCallsignSavedData get(ServerLevel level) {
        return (BlockEntityCallsignSavedData)level.getDataStorage().computeIfAbsent(new SavedData.Factory(BlockEntityCallsignSavedData::new, BlockEntityCallsignSavedData::load), DATA_NAME);
    }

    private static BlockEntityCallsignSavedData load(@NotNull CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag callData = nbt.getCompound("block_entity_callsign_data");
        BlockEntityCallsignSavedData data = new BlockEntityCallsignSavedData();
        callsigns.clear();
        for (String globalPosKey : callData.getAllKeys()) {
            try {
                CompoundTag posData = callData.getCompound(globalPosKey);
                GlobalPos globalPos = GlobalPos.CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)posData.get("globalPos")).result().orElse(null);
                if (globalPos == null) continue;
                String callsign = posData.getString("callsign");
                LicenseClass licenseClass = LicenseClass.valueOf(posData.getString("licenseClass"));
                BlockEntityCallsignData blockData = new BlockEntityCallsignData(globalPos, callsign, licenseClass);
                callsigns.put(globalPos, blockData);
            }
            catch (IllegalArgumentException e) {
                Radiocraft.LOGGER.error("Invalid block entity callsign data for position {}", (Object)globalPosKey);
            }
        }
        return data;
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag callData = new CompoundTag();
        int index = 0;
        for (GlobalPos globalPos : callsigns.keySet()) {
            BlockEntityCallsignData data = callsigns.get(globalPos);
            CompoundTag posData = new CompoundTag();
            GlobalPos.CODEC.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)globalPos).result().ifPresent(tag -> posData.put("globalPos", tag));
            posData.putString("callsign", data.callsign());
            posData.putString("licenseClass", data.licenseClass().name());
            callData.put("entry_" + index, (Tag)posData);
            ++index;
        }
        nbt.put("block_entity_callsign_data", (Tag)callData);
        return nbt;
    }

    @Override
    public ArrayList<String> getCallsigns() {
        return callsigns.values().stream().map(BlockEntityCallsignData::callsign).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
    }

    @Override
    public BlockEntityCallsignData getCallsignData(String callsign) {
        return callsigns.values().stream().filter(data -> data.callsign().equals(callsign)).findFirst().orElse(null);
    }

    @Override
    public BlockEntityCallsignData getCallsignData(GlobalPos pos, BlockEntityCallsignData callsignData) {
        return callsigns.get(pos);
    }

    @Override
    public IBlockEntityCallsignCapability setCallsignData(GlobalPos pos, BlockEntityCallsignData callsignData) {
        callsigns.put(pos, callsignData);
        this.setDirty();
        return this;
    }

    @Override
    public IBlockEntityCallsignCapability resetCallsign(GlobalPos pos) {
        callsigns.remove(pos);
        this.setDirty();
        return this;
    }
}

