/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.entities;

import com.arrl.radiocraft.api.capabilities.IAntennaWireHolderCapability;
import com.arrl.radiocraft.common.blockentities.AntennaBlockEntity;
import com.arrl.radiocraft.common.capabilities.RadiocraftCapabilities;
import com.arrl.radiocraft.common.entities.AntennaWirePart;
import com.arrl.radiocraft.common.entities.IAntennaWire;
import com.arrl.radiocraft.common.init.RadiocraftEntityTypes;
import com.arrl.radiocraft.common.init.RadiocraftItems;
import com.arrl.radiocraft.common.init.RadiocraftTags;
import com.arrl.radiocraft.common.network.clientbound.CWireEndPosUpdatePacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import net.neoforged.neoforge.entity.PartEntity;
import net.neoforged.neoforge.network.PacketDistributor;

public class AntennaWire
extends Entity
implements IAntennaWire,
IEntityWithComplexSpawn {
    private static final EntityDataAccessor<Optional<UUID>> DATA_HOLDER_UUID = SynchedEntityData.defineId(AntennaWire.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private final AntennaWirePart[] parts;
    private final AntennaWirePart endPart = new AntennaWirePart(this, "end");
    private Player holder = null;
    private int checkInterval = 0;
    private boolean checkEnabled = true;

    public AntennaWire(EntityType<AntennaWire> type, Level level) {
        this(level, new BlockPos(0, 0, 0));
    }

    public AntennaWire(Level level, BlockPos pos) {
        super(RadiocraftEntityTypes.ANTENNA_WIRE.get(), level);
        this.parts = new AntennaWirePart[]{this.endPart};
        this.setId(ENTITY_COUNTER.getAndAdd(this.getParts().length + 1) + 1);
        this.noPhysics = true;
        this.noCulling = true;
        this.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
        this.endPart.setPos(this.position());
    }

    public static AntennaWire createWire(Level level, BlockPos pos, Player holder) {
        AntennaWire entity = new AntennaWire(level, pos);
        if (holder != null) {
            entity.setHolder(holder);
            ((IAntennaWireHolderCapability)holder.getCapability(RadiocraftCapabilities.ANTENNA_WIRE_HOLDERS)).setHeldPos(holder, pos);
        }
        level.addFreshEntity((Entity)entity);
        return entity;
    }

    public static List<IAntennaWire> getWires(Level level, BlockPos pos) {
        int posX = pos.getX();
        int posY = pos.getY();
        int posZ = pos.getZ();
        AABB aabb = new AABB((double)posX, (double)posY, (double)posZ, (double)posX + 1.0, (double)posY + 1.0, (double)posZ + 1.0);
        List wires = level.getEntitiesOfClass(AntennaWire.class, aabb, entity -> !entity.isRemoved());
        List parts = level.getEntitiesOfClass(AntennaWirePart.class, aabb, entity -> !entity.isRemoved());
        ArrayList<IAntennaWire> out = new ArrayList<IAntennaWire>();
        out.addAll(wires);
        out.addAll(parts);
        return out;
    }

    public static AntennaWire getFirstHeldWire(Level level, BlockPos pos, Player player) {
        int posX = pos.getX();
        int posY = pos.getY();
        int posZ = pos.getZ();
        List wires = level.getEntitiesOfClass(AntennaWire.class, new AABB((double)posX, (double)posY, (double)posZ, (double)posX + 1.0, (double)posY + 1.0, (double)posZ + 1.0));
        for (AntennaWire wire : wires) {
            if (wire.getWireHolder() != player) continue;
            return wire;
        }
        return null;
    }

    @Override
    public void updateAntennas() {
        if (this.checkEnabled) {
            this.checkEnabled = false;
            BlockEntity blockEntity = this.level().getBlockEntity(this.blockPosition());
            if (blockEntity instanceof AntennaBlockEntity) {
                AntennaBlockEntity be = (AntennaBlockEntity)blockEntity;
                be.markAntennaChanged();
            }
            this.endPart.updateAntennas();
            for (IAntennaWire wire : AntennaWire.getWires(this.level(), this.blockPosition())) {
                wire.updateAntennas();
            }
            this.checkEnabled = true;
        }
    }

    public void tick() {
        if (!this.level().isClientSide && this.checkInterval++ == 60) {
            this.checkInterval = 0;
            Player holder = this.getWireHolder();
            if (!this.isRemoved() && !this.survives()) {
                if (holder != null) {
                    ((IAntennaWireHolderCapability)holder.getCapability(RadiocraftCapabilities.ANTENNA_WIRE_HOLDERS)).setHeldPos(holder, null);
                }
                this.discard();
                this.endPart.discard();
                this.playBreakSound();
                this.updateAntennas();
            }
        }
    }

    public boolean survives() {
        if (this.level().getBlockState(this.blockPosition()).is(RadiocraftTags.Blocks.ANTENNA_WIRE_HOLDERS)) {
            Player holder = this.getWireHolder();
            if (holder != null) {
                return !holder.isRemoved();
            }
            return this.level().getBlockState(this.getEndPos()).is(RadiocraftTags.Blocks.ANTENNA_WIRE_HOLDERS);
        }
        return false;
    }

    public Player getWireHolder() {
        Optional optionalUUID = (Optional)this.entityData.get(DATA_HOLDER_UUID);
        if (optionalUUID.isPresent()) {
            UUID uuid = (UUID)optionalUUID.get();
            if (this.holder == null || !uuid.equals(this.holder.getUUID())) {
                this.holder = this.level().getPlayerByUUID(uuid);
            }
            return this.holder;
        }
        return null;
    }

    public void setEndPos(BlockPos endPos) {
        this.endPart.setPos(new Vec3((double)endPos.getX() + 0.5, (double)endPos.getY() + 0.5, (double)endPos.getZ() + 0.5));
        if (!this.level().isClientSide) {
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.level()), (ChunkPos)this.level().getChunkAt(this.endPart.getEndPos()).getPos(), (CustomPacketPayload)new CWireEndPosUpdatePacket(this.getId(), endPos.asLong()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public BlockPos getEndPos() {
        return this.endPart.blockPosition();
    }

    @Override
    public BlockPos getStartPos() {
        return this.blockPosition();
    }

    @Override
    public double getLength() {
        return this.endPart.position().distanceTo(this.position());
    }

    @Override
    public boolean isPairedWith(IAntennaWire other) {
        return other == this.endPart;
    }

    public AntennaWirePart getEndPart() {
        return this.endPart;
    }

    public void setHolder(Player player) {
        if (player != null) {
            this.entityData.set(DATA_HOLDER_UUID, Optional.of(player.getUUID()));
        } else {
            this.entityData.set(DATA_HOLDER_UUID, Optional.empty());
        }
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        nbt.putLong("endPos", this.getEndPos().asLong());
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        this.setEndPos(BlockPos.of((long)nbt.getLong("endPos")));
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        pBuilder.define(DATA_HOLDER_UUID, Optional.empty());
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return distance < 1024.0;
    }

    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)RadiocraftItems.ANTENNA_WIRE.get());
    }

    public boolean isMultipartEntity() {
        return true;
    }

    @Nullable
    public PartEntity<?>[] getParts() {
        return this.parts;
    }

    public Vec3 getRopeHoldPosition(float partialTicks) {
        return this.position();
    }

    public Vec3 getLeashOffset(float partialTicks) {
        return Vec3.ZERO;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        if (!this.isRemoved() && !this.level().isClientSide) {
            this.kill();
            this.markHurt();
            this.playBreakSound();
        }
        return true;
    }

    public void playBreakSound() {
        this.playSound(SoundEvents.LEASH_KNOT_BREAK, 1.0f, 1.0f);
    }

    public void setId(int id) {
        super.setId(id);
        int newId = id + 1;
        for (PartEntity<?> part : this.getParts()) {
            part.setId(newId++);
        }
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buffer) {
        buffer.writeLong(this.endPart.blockPosition().asLong());
    }

    public void readSpawnData(RegistryFriendlyByteBuf additionalData) {
        this.setEndPos(BlockPos.of((long)additionalData.readLong()));
    }
}

