/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.entities;

import com.arrl.radiocraft.common.blockentities.AntennaBlockEntity;
import com.arrl.radiocraft.common.entities.AntennaWire;
import com.arrl.radiocraft.common.entities.IAntennaWire;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.PartEntity;

public class AntennaWirePart
extends PartEntity<AntennaWire>
implements IAntennaWire {
    public final AntennaWire parent;
    public final String name;
    private boolean checkEnabled = true;

    public AntennaWirePart(AntennaWire parent, String name) {
        super((Entity)parent);
        this.parent = parent;
        this.name = name;
    }

    protected void readAdditionalSaveData(CompoundTag nbt) {
    }

    protected void addAdditionalSaveData(CompoundTag nbt) {
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
    }

    public boolean hurt(DamageSource source, float amount) {
        return !this.isInvulnerableTo(source) && this.parent.hurt(source, amount);
    }

    public boolean is(Entity entity) {
        return this == entity || this.parent == entity;
    }

    public boolean shouldBeSaved() {
        return false;
    }

    public ItemStack getPickResult() {
        return this.parent.getPickResult();
    }

    public Vec3 getRopeHoldPosition(float partialTicks) {
        return this.position();
    }

    public Vec3 getLeashOffset(float partialTicks) {
        return this.parent.getLeashOffset(partialTicks);
    }

    public EntityDimensions getDimensions(Pose pose) {
        return this.parent.getDimensions(pose);
    }

    @Override
    public BlockPos getEndPos() {
        return this.parent.blockPosition();
    }

    @Override
    public BlockPos getStartPos() {
        return this.blockPosition();
    }

    @Override
    public double getLength() {
        return this.parent.getLength();
    }

    @Override
    public boolean isPairedWith(IAntennaWire other) {
        return other == this.parent;
    }

    @Override
    public void updateAntennas() {
        if (this.checkEnabled) {
            this.checkEnabled = false;
            BlockEntity blockEntity = this.level().getBlockEntity(this.blockPosition());
            if (blockEntity instanceof AntennaBlockEntity) {
                AntennaBlockEntity be = (AntennaBlockEntity)blockEntity;
                be.markAntennaChanged();
            }
            this.parent.updateAntennas();
            this.checkEnabled = true;
        }
    }
}

