/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.init;

import com.arrl.radiocraft.common.datacomponents.HandheldRadioState;
import com.arrl.radiocraft.common.init.RadiocraftBlocks;
import com.arrl.radiocraft.common.init.RadiocraftDataComponent;
import com.arrl.radiocraft.common.items.AntennaAnalyzerItem;
import com.arrl.radiocraft.common.items.AntennaPoleItem;
import com.arrl.radiocraft.common.items.AntennaWireItem;
import com.arrl.radiocraft.common.items.SmallBatteryItem;
import com.arrl.radiocraft.common.items.VHFHandheldItem;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;

public class RadiocraftItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.createItems((String)"radiocraft");
    public static final Supplier<Item> RADIO_CRYSTAL = RadiocraftItems.simpleItem("radio_crystal", null);
    public static final Supplier<Item> RADIO_SPEAKER = RadiocraftItems.simpleItem("radio_speaker", null);
    public static final Supplier<Item> HAND_MICROPHONE = RadiocraftItems.simpleItem("hand_microphone", null);
    public static final Supplier<Item> HF_CIRCUIT_BOARD = RadiocraftItems.simpleItem("hf_circuit_board", null);
    public static final DeferredHolder<Item, SmallBatteryItem> SMALL_BATTERY = ITEMS.register("small_battery", () -> new SmallBatteryItem(new Item.Properties().stacksTo(1)));
    public static final Supplier<Item> FERRITE_CORE = RadiocraftItems.simpleItem("ferrite_core", null);
    public static final Supplier<Item> COAXIAL_CORE = RadiocraftItems.simpleItem("coaxial_core", null);
    public static final Supplier<Item> ANTENNA_ANALYZER = ITEMS.register("antenna_analyzer", () -> new AntennaAnalyzerItem(new Item.Properties().stacksTo(1)));
    public static final DeferredHolder<Item, VHFHandheldItem> VHF_HANDHELD = ITEMS.register("vhf_handheld", () -> new VHFHandheldItem(new Item.Properties().stacksTo(1).component((DataComponentType)RadiocraftDataComponent.HANDHELD_RADIO_STATE_COMPONENT.value(), (Object)HandheldRadioState.getDefault())));
    public static final DeferredHolder<Item, AntennaWireItem> ANTENNA_WIRE = ITEMS.register("antenna_wire", () -> new AntennaWireItem(new Item.Properties()));
    public static final Supplier<BlockItem> WIRE = RadiocraftItems.simpleBlockItem("wire", RadiocraftBlocks.WIRE);
    public static final Supplier<BlockItem> WATERPROOF_WIRE = RadiocraftItems.simpleBlockItem("waterproof_wire", RadiocraftBlocks.WATERPROOF_WIRE);
    public static final Supplier<BlockItem> SOLAR_PANEL = RadiocraftItems.simpleBlockItem("solar_panel", RadiocraftBlocks.SOLAR_PANEL);
    public static final Supplier<BlockItem> LARGE_BATTERY = RadiocraftItems.simpleBlockItem("large_battery", RadiocraftBlocks.LARGE_BATTERY);
    public static final Supplier<BlockItem> CHARGE_CONTROLLER = RadiocraftItems.simpleBlockItem("charge_controller", RadiocraftBlocks.CHARGE_CONTROLLER);
    public static final Supplier<BlockItem> VHF_BASE_STATION = RadiocraftItems.simpleBlockItem("vhf_base_station", RadiocraftBlocks.VHF_BASE_STATION);
    public static final Supplier<BlockItem> VHF_RECEIVER = RadiocraftItems.simpleBlockItem("vhf_receiver", RadiocraftBlocks.VHF_RECEIVER);
    public static final Supplier<BlockItem> VHF_REPEATER = RadiocraftItems.simpleBlockItem("vhf_repeater", RadiocraftBlocks.VHF_REPEATER);
    public static final Supplier<BlockItem> HF_RADIO_10M = RadiocraftItems.simpleBlockItem("hf_radio_10m", RadiocraftBlocks.HF_RADIO_10M);
    public static final Supplier<BlockItem> HF_RADIO_20M = RadiocraftItems.simpleBlockItem("hf_radio_20m", RadiocraftBlocks.HF_RADIO_20M);
    public static final Supplier<BlockItem> HF_RADIO_40M = RadiocraftItems.simpleBlockItem("hf_radio_40m", RadiocraftBlocks.HF_RADIO_40M);
    public static final Supplier<BlockItem> HF_RADIO_80M = RadiocraftItems.simpleBlockItem("hf_radio_80m", RadiocraftBlocks.HF_RADIO_80M);
    public static final Supplier<BlockItem> HF_RECEIVER = RadiocraftItems.simpleBlockItem("hf_receiver", RadiocraftBlocks.HF_RECEIVER);
    public static final Supplier<BlockItem> ALL_BAND_RADIO = RadiocraftItems.simpleBlockItem("all_band_radio", RadiocraftBlocks.ALL_BAND_RADIO);
    public static final Supplier<BlockItem> QRP_RADIO_20M = RadiocraftItems.simpleBlockItem("qrp_radio_20m", RadiocraftBlocks.QRP_RADIO_20M);
    public static final Supplier<BlockItem> QRP_RADIO_40M = RadiocraftItems.simpleBlockItem("qrp_radio_40m", RadiocraftBlocks.QRP_RADIO_40M);
    public static final Supplier<BlockItem> DIGITAL_INTERFACE = RadiocraftItems.simpleBlockItem("digital_interface", RadiocraftBlocks.DIGITAL_INTERFACE);
    public static final DeferredHolder<Item, AntennaPoleItem> ANTENNA_POLE = ITEMS.register("antenna_pole", () -> new AntennaPoleItem((Block)RadiocraftBlocks.ANTENNA_POLE.get(), new Item.Properties()));
    public static final Supplier<BlockItem> DUPLEXER = RadiocraftItems.simpleBlockItem("duplexer", RadiocraftBlocks.DUPLEXER);
    public static final Supplier<BlockItem> ANTENNA_TUNER = RadiocraftItems.simpleBlockItem("antenna_tuner", RadiocraftBlocks.ANTENNA_TUNER);
    public static final Supplier<BlockItem> ANTENNA_CONNECTOR = RadiocraftItems.simpleBlockItem("antenna_connector", RadiocraftBlocks.ANTENNA_CONNECTOR);
    public static final Supplier<BlockItem> BALUN_ONE_TO_ONE = RadiocraftItems.simpleBlockItem("balun_one_to_one", RadiocraftBlocks.BALUN_ONE_TO_ONE);
    public static final Supplier<BlockItem> BALUN_TWO_TO_ONE = RadiocraftItems.simpleBlockItem("balun_two_to_one", RadiocraftBlocks.BALUN_TWO_TO_ONE);
    public static final Supplier<BlockItem> COAX_WIRE = RadiocraftItems.simpleBlockItem("coax_wire", RadiocraftBlocks.COAX_WIRE);
    public static final Supplier<BlockItem> YAGI_ANTENNA = RadiocraftItems.simpleBlockItem("yagi_antenna", RadiocraftBlocks.YAGI_ANTENNA);
    public static final Supplier<BlockItem> J_POLE_ANTENNA = RadiocraftItems.simpleBlockItem("j_pole_antenna", RadiocraftBlocks.J_POLE_ANTENNA);
    public static final Supplier<BlockItem> SLIM_JIM_ANTENNA = RadiocraftItems.simpleBlockItem("slim_jim_antenna", RadiocraftBlocks.SLIM_JIM_ANTENNA);
    public static final Supplier<BlockItem> SOLAR_WEATHER_STATION = RadiocraftItems.simpleBlockItem("solar_weather_station", RadiocraftBlocks.SOLAR_WEATHER_STATION);
    public static final Supplier<BlockItem> MICROPHONE = RadiocraftItems.simpleBlockItem("microphone", RadiocraftBlocks.MICROPHONE);

    private static Supplier<Item> simpleItem(String name, final Component tooltip) {
        if (tooltip != null) {
            return ITEMS.register(name, () -> new Item(new Item.Properties()){

                public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
                    super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
                    tooltipComponents.add(tooltip);
                }
            });
        }
        return ITEMS.register(name, () -> new Item(new Item.Properties()));
    }

    private static Supplier<BlockItem> simpleBlockItem(String name, Supplier<? extends Block> block) {
        return ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }
}

