/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.items;

import com.arrl.radiocraft.Radiocraft;
import com.arrl.radiocraft.api.antenna.IAntenna;
import com.arrl.radiocraft.common.items.VHFHandheldItem;
import com.arrl.radiocraft.common.radio.antenna.AntennaNetwork;
import com.arrl.radiocraft.common.radio.antenna.networks.AntennaNetworkManager;
import com.arrl.radiocraft.common.radio.antenna.types.RubberDuckyAntennaType;
import com.arrl.radiocraft.common.radio.antenna.types.data.RubberDuckyAntennaData;
import com.arrl.radiocraft.common.radio.voice.handheld.PlayerRadio;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class AntennaAnalyzerItem
extends Item {
    public AntennaAnalyzerItem(Item.Properties properties) {
        super(properties);
    }

    private Set<IAntenna> getAntennasAt(Level level, BlockPos pos) {
        HashSet<IAntenna> allAntennas = new HashSet<IAntenna>();
        for (Map.Entry<ResourceLocation, AntennaNetwork> entry : AntennaNetworkManager.networks.entrySet()) {
            for (IAntenna antenna : entry.getValue().allAntennas()) {
                IAntenna.AntennaPos ap = antenna.getAntennaPos();
                if (ap == null || ap.level() != level || !ap.position().equals((Object)pos)) continue;
                allAntennas.add(antenna);
            }
        }
        return allAntennas;
    }

    private Set<IAntenna> getPlayerAntennas(Player player) {
        return AntennaNetworkManager.getNetwork(AntennaNetworkManager.VHF_ID).allAntennas().stream().filter(antenna -> {
            IAntenna.AntennaPos ap = antenna.getAntennaPos();
            Player test = antenna.getPlayer();
            return test != null && test.equals((Object)player);
        }).collect(Collectors.toSet());
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        if (context.getLevel().isClientSide()) {
            return InteractionResult.PASS;
        }
        Player player = context.getPlayer();
        Set<IAntenna> antennas = this.getAntennasAt(context.getLevel(), context.getClickedPos());
        if (!antennas.isEmpty()) {
            IAntenna antenna = antennas.iterator().next();
            if (player != null) {
                player.displayClientMessage((Component)Component.translatable((String)Radiocraft.translationKey("message", "antenna_analyzer.network_found"), (Object[])new Object[]{antenna.getAntennaPos(), antennas.size()}), true);
                return InteractionResult.CONSUME;
            }
        }
        if (player != null) {
            Set<IAntenna> playerRadios = this.getPlayerAntennas(player);
            if (!playerRadios.isEmpty()) {
                playerRadios.forEach(it -> {
                    if (it.getType() instanceof RubberDuckyAntennaType) {
                        RubberDuckyAntennaType type = (RubberDuckyAntennaType)it.getType();
                        RubberDuckyAntennaData data = (RubberDuckyAntennaData)it.getData();
                        boolean hasHandheldRadio = player.getInventory().items.stream().anyMatch(itemStack -> itemStack.getItem() instanceof VHFHandheldItem);
                        if (hasHandheldRadio) {
                            String formattedLength = String.format("%.3f", data.getLength());
                            String formattedSwr = String.format("%.3f", type.getSWR(data, 1.4652E8f));
                            player.sendSystemMessage((Component)Component.translatable((String)Radiocraft.translationKey("message", "antenna_analyzer.handheld_with_stats"), (Object[])new Object[]{formattedLength, formattedSwr}));
                        } else {
                            player.sendSystemMessage((Component)Component.translatable((String)Radiocraft.translationKey("message", "antenna_analyzer.no_handheld")));
                        }
                    } else {
                        boolean hasHandheldRadio = player.getInventory().items.stream().anyMatch(itemStack -> itemStack.getItem() instanceof VHFHandheldItem);
                        if (hasHandheldRadio) {
                            player.sendSystemMessage((Component)Component.translatable((String)Radiocraft.translationKey("message", "antenna_analyzer.unknown_handheld_antenna")));
                        } else {
                            player.sendSystemMessage((Component)Component.translatable((String)Radiocraft.translationKey("message", "antenna_analyzer.no_handheld")));
                        }
                    }
                });
                return InteractionResult.CONSUME;
            }
            player.displayClientMessage((Component)Component.translatable((String)Radiocraft.translationKey("message", "antenna_analyzer.no_networks_at"), (Object[])new Object[]{context.getClickedPos()}), true);
            if (Radiocraft.IS_DEVELOPMENT_ENV) {
                Set allAntennasExceptPlayer = AntennaNetworkManager.getAllAntennas().stream().filter(it -> !(it instanceof PlayerRadio)).collect(Collectors.toSet());
                player.sendSystemMessage((Component)Component.translatable((String)Radiocraft.translationKey("message", "antenna_analyzer.development_summary"), (Object[])new Object[]{allAntennasExceptPlayer.size(), String.join((CharSequence)" ", allAntennasExceptPlayer.stream().map(Object::toString).toList())}));
            }
        }
        return InteractionResult.PASS;
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return false;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)Radiocraft.translationKey("tooltip", "antenna_analyzer")));
    }
}

