/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.items;

import com.arrl.radiocraft.Radiocraft;
import com.arrl.radiocraft.api.capabilities.IAntennaWireHolderCapability;
import com.arrl.radiocraft.common.capabilities.RadiocraftCapabilities;
import com.arrl.radiocraft.common.entities.AntennaWire;
import com.arrl.radiocraft.common.init.RadiocraftTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;

public class AntennaWireItem
extends Item {
    public AntennaWireItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        Player player = context.getPlayer();
        if (state.is(RadiocraftTags.Blocks.ANTENNA_WIRE_HOLDERS)) {
            level.gameEvent((Holder)GameEvent.BLOCK_ATTACH, pos, GameEvent.Context.of((Entity)player));
            if (!level.isClientSide && player != null) {
                IAntennaWireHolderCapability cap = (IAntennaWireHolderCapability)player.getCapability(RadiocraftCapabilities.ANTENNA_WIRE_HOLDERS);
                if (cap != null) {
                    BlockPos heldPos = cap.getHeldPos(player);
                    if (heldPos == null) {
                        AntennaWire entity = AntennaWire.createWire(level, pos, player);
                        player.sendSystemMessage((Component)Component.literal((String)("Antenna Wire started at " + String.valueOf(pos))));
                        entity.playSound(SoundEvents.LEASH_KNOT_PLACE, 1.0f, 1.0f);
                        level.playSound(null, entity.blockPosition(), SoundEvents.LEASH_KNOT_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                        cap.setHeldPos(player, pos);
                    } else if (!pos.equals((Object)cap.getHeldPos(player))) {
                        player.sendSystemMessage((Component)Component.literal((String)("Antenna Wire ended at " + String.valueOf(pos))));
                        AntennaWire entity = AntennaWire.getFirstHeldWire(level, heldPos, player);
                        if (entity != null) {
                            entity.setEndPos(pos);
                            entity.setHolder(null);
                            level.playSound(null, entity.getEndPos(), SoundEvents.LEASH_KNOT_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                            entity.updateAntennas();
                        } else {
                            Radiocraft.LOGGER.warn("Could not find player's first held wire.");
                        }
                        cap.setHeldPos(player, null);
                    } else {
                        player.sendSystemMessage((Component)Component.literal((String)"Antenna Wire cannot start and end at the same place"));
                    }
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }
}

