/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.items;

import com.arrl.radiocraft.api.capabilities.IVHFHandheldCapability;
import com.arrl.radiocraft.client.screens.radios.VHFHandheldScreen;
import com.arrl.radiocraft.common.capabilities.RadiocraftCapabilities;
import com.arrl.radiocraft.common.init.RadiocraftItems;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class VHFHandheldItem
extends Item {
    public VHFHandheldItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack item = player.getItemInHand(hand);
        if (hand == InteractionHand.MAIN_HAND) {
            if (level.isClientSide() && player.isCrouching()) {
                VHFHandheldScreen.open(player.getInventory().selected);
            }
            if (!player.isCrouching()) {
                return InteractionResultHolder.pass((Object)item);
            }
        } else if (!level.isClientSide()) {
            IVHFHandheldCapability cap;
            ItemStack mainItem = player.getItemInHand(InteractionHand.MAIN_HAND);
            if (player.isCrouching() && (mainItem.getItem() == RadiocraftItems.SMALL_BATTERY.get() || mainItem.isEmpty()) && (cap = (IVHFHandheldCapability)item.getCapability(RadiocraftCapabilities.VHF_HANDHELDS)) != null) {
                player.setItemInHand(InteractionHand.MAIN_HAND, cap.getBattery());
                cap.setBattery(mainItem);
            }
        }
        return super.use(level, player, hand);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public void inventoryTick(ItemStack item, Level level, Entity entity, int slot, boolean isSelected) {
        if (!level.isClientSide() && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            IVHFHandheldCapability cap = (IVHFHandheldCapability)RadiocraftCapabilities.VHF_HANDHELDS.getCapability(item, null);
            if (cap == null || cap.isPowered()) {
                // empty if block
            }
        }
    }
}

