/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.menus;

import com.arrl.radiocraft.common.blockentities.ChargeControllerBlockEntity;
import com.arrl.radiocraft.common.init.RadiocraftBlocks;
import com.arrl.radiocraft.common.init.RadiocraftItems;
import com.arrl.radiocraft.common.init.RadiocraftMenuTypes;
import com.arrl.radiocraft.common.menus.MenuUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class ChargeControllerMenu
extends AbstractContainerMenu {
    public final ChargeControllerBlockEntity blockEntity;
    private final ContainerLevelAccess canInteractWithCallable;
    private final ContainerData data;

    public ChargeControllerMenu(int id, Inventory playerInventory, @NotNull ChargeControllerBlockEntity be, ContainerData data) {
        super(RadiocraftMenuTypes.CHARGE_CONTROLLER.get(), id);
        this.blockEntity = be;
        this.canInteractWithCallable = ContainerLevelAccess.create((Level)be.getLevel(), (BlockPos)be.getBlockPos());
        this.data = data;
        this.addDataSlots(this.data);
        this.addSlot((Slot)new BatterySlot(be.inventory, 0, 66, 41));
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)playerInventory, x + y * 9 + 9, 8 + x * 18, 131 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)playerInventory, x, 8 + 18 * x, 189));
        }
    }

    public ChargeControllerMenu(int id, Inventory playerInventory, FriendlyByteBuf data) {
        this(id, playerInventory, MenuUtils.getBlockEntity(playerInventory, data, ChargeControllerBlockEntity.class), (ContainerData)new SimpleContainerData(1));
    }

    public int getPowerTick() {
        return this.data.get(0);
    }

    public boolean stillValid(@NotNull Player player) {
        return ChargeControllerMenu.stillValid((ContainerLevelAccess)this.canInteractWithCallable, (Player)player, (Block)((Block)RadiocraftBlocks.CHARGE_CONTROLLER.get()));
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        return ItemStack.EMPTY;
    }

    public static class BatterySlot
    extends SlotItemHandler {
        public BatterySlot(ItemStackHandler inventory, int index, int x, int y) {
            super((IItemHandler)inventory, index, x, y);
        }

        public boolean mayPlace(ItemStack stack) {
            return stack.getItem() == RadiocraftItems.SMALL_BATTERY.get();
        }
    }
}

