/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.menus;

import com.arrl.radiocraft.common.blockentities.LargeBatteryBlockEntity;
import com.arrl.radiocraft.common.init.RadiocraftBlocks;
import com.arrl.radiocraft.common.init.RadiocraftMenuTypes;
import com.arrl.radiocraft.common.menus.MenuUtils;
import com.arrl.radiocraft.common.menus.slots.IntSplitDataSlot;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class LargeBatteryMenu
extends AbstractContainerMenu {
    public final LargeBatteryBlockEntity blockEntity;
    private final ContainerLevelAccess canInteractWithCallable;
    private final IntSplitDataSlot dataEnergy;
    private final IntSplitDataSlot dataMaxEnergy;

    public LargeBatteryMenu(int id, LargeBatteryBlockEntity blockEntity, IntSplitDataSlot dataEnergy, IntSplitDataSlot dataMaxEnergy) {
        super(RadiocraftMenuTypes.LARGE_BATTERY.get(), id);
        this.blockEntity = blockEntity;
        this.canInteractWithCallable = ContainerLevelAccess.create((Level)Objects.requireNonNull(blockEntity.getLevel()), (BlockPos)blockEntity.getBlockPos());
        this.dataEnergy = dataEnergy;
        this.dataMaxEnergy = dataMaxEnergy;
        this.addDataSlots(dataEnergy);
        this.addDataSlots(dataMaxEnergy);
    }

    public LargeBatteryMenu(int id, Inventory playerInventory, FriendlyByteBuf data) {
        this(id, MenuUtils.getBlockEntity(playerInventory, data, LargeBatteryBlockEntity.class), new IntSplitDataSlot(), new IntSplitDataSlot());
    }

    public int getCurrentPower() {
        return this.dataEnergy.get(2);
    }

    public int getMaxPower() {
        return this.dataMaxEnergy.get(2);
    }

    public boolean stillValid(@NotNull Player player) {
        return LargeBatteryMenu.stillValid((ContainerLevelAccess)this.canInteractWithCallable, (Player)player, (Block)((Block)RadiocraftBlocks.LARGE_BATTERY.get()));
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        return null;
    }
}

