/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.menus;

import com.arrl.radiocraft.common.blockentities.radio.RadioBlockEntity;
import com.arrl.radiocraft.common.radio.Band;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class RadioMenu<T extends RadioBlockEntity>
extends AbstractContainerMenu {
    public T blockEntity;
    private final Block validBlock;
    private final ContainerLevelAccess canInteractWithCallable;
    private final ContainerData data;

    public RadioMenu(MenuType<?> type, int id, T blockEntity, Block validBlock) {
        super(type, id);
        this.blockEntity = blockEntity;
        this.canInteractWithCallable = ContainerLevelAccess.create((Level)Objects.requireNonNull(blockEntity.getLevel()), (BlockPos)blockEntity.getBlockPos());
        this.validBlock = validBlock;
        this.data = ((RadioBlockEntity)blockEntity).getDataSlots();
        this.addDataSlots(this.data);
    }

    public float getFrequency() {
        return ((RadioBlockEntity)this.blockEntity).getFrequency();
    }

    public void setFrequency(float value) {
        ((RadioBlockEntity)this.blockEntity).setFrequency(value);
    }

    public Band getBand() {
        return ((RadioBlockEntity)this.blockEntity).getBand();
    }

    public void setBand(Band band) {
        ((RadioBlockEntity)this.blockEntity).setBand(band);
    }

    public boolean isPowered() {
        return this.data.get(0) == 1;
    }

    public boolean stillValid(@NotNull Player player) {
        return RadioMenu.stillValid((ContainerLevelAccess)this.canInteractWithCallable, (Player)player, (Block)this.validBlock);
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        return null;
    }

    public void removed(@NotNull Player player) {
        super.removed(player);
        if (this.blockEntity != null) {
            ((RadioBlockEntity)this.blockEntity).setPTTDown(false);
        }
    }
}

