/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.menus.slots;

import com.arrl.radiocraft.common.menus.slots.IntSplitDataSlot;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class IntRefSplitDataSlot
extends IntSplitDataSlot {
    private final Consumer<Integer> setter;
    private final Supplier<Integer> getter;

    public IntRefSplitDataSlot(Consumer<Integer> setter, Supplier<Integer> getter) {
        this.setter = setter;
        this.getter = getter;
    }

    @Override
    public int get(int index) {
        return switch (index) {
            case 0 -> this.getter.get() & 0xFFFF0000;
            case 1 -> this.getter.get() & 0xFFFF;
            case 3 -> this.getter.get();
            default -> 0;
        };
    }

    @Override
    public void set(int index, int value) {
        if (index == 0) {
            int leastSignificant = this.get(1);
            this.setter.accept(leastSignificant + value);
        } else if (index == 1) {
            int mostSignificant = this.get(0);
            this.setter.accept(mostSignificant + value);
        }
    }
}

