/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.network.clientbound;

import com.arrl.radiocraft.Radiocraft;
import com.arrl.radiocraft.common.entities.AntennaWire;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record CWireEndPosUpdatePacket(int id, long endPos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CWireEndPosUpdatePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"radiocraft", (String)"wire_end_pos"));
    public static final StreamCodec<ByteBuf, CWireEndPosUpdatePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, CWireEndPosUpdatePacket::id, (StreamCodec)ByteBufCodecs.VAR_LONG, CWireEndPosUpdatePacket::endPos, CWireEndPosUpdatePacket::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(CWireEndPosUpdatePacket data, IPayloadContext context) {
        context.enqueueWork(() -> {
            Radiocraft.LOGGER.info("Received CWireEndPosUpdatePacket for entity {} at {}", (Object)context.player().getName(), (Object)data.endPos());
            try (Level level = context.player().level();){
                Entity e = level.getEntity(data.id);
                if (e instanceof AntennaWire) {
                    ((AntennaWire)e).setEndPos(BlockPos.of((long)data.endPos()));
                } else if (e != null) {
                    Radiocraft.LOGGER.error("Received CWireEndPosUpdatePacket for entity {} which is not an AntennaWire", (Object)e.getName());
                }
            }
            catch (Exception e) {
                Radiocraft.LOGGER.error("Error handling CWireEndPosUpdatePacket", (Throwable)e);
            }
        });
    }
}

