/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.network.serverbound;

import com.arrl.radiocraft.Radiocraft;
import com.arrl.radiocraft.api.capabilities.IVHFHandheldCapability;
import com.arrl.radiocraft.common.capabilities.RadiocraftCapabilities;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class SHandheldRadioUpdatePacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<SHandheldRadioUpdatePacket> TYPE = new CustomPacketPayload.Type(Radiocraft.id("s_handheld_radio_update"));
    int index;
    boolean powered;
    boolean ptt;
    float gain;
    float micGain;
    float frequencyHertz;
    public static final StreamCodec<ByteBuf, SHandheldRadioUpdatePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, SHandheldRadioUpdatePacket::getIndex, (StreamCodec)ByteBufCodecs.BYTE, SHandheldRadioUpdatePacket::packBools, (StreamCodec)ByteBufCodecs.FLOAT, SHandheldRadioUpdatePacket::getGain, (StreamCodec)ByteBufCodecs.FLOAT, SHandheldRadioUpdatePacket::getMicGain, (StreamCodec)ByteBufCodecs.FLOAT, SHandheldRadioUpdatePacket::getFrequencyHertz, SHandheldRadioUpdatePacket::new);

    public SHandheldRadioUpdatePacket(int index, boolean powered, boolean ptt, float gain, float micGain, float frequencyHertz) {
        this.index = index;
        this.powered = powered;
        this.ptt = ptt;
        this.gain = gain;
        this.micGain = micGain;
        this.frequencyHertz = frequencyHertz;
    }

    private SHandheldRadioUpdatePacket(Integer index, Byte packed, Float gain, Float micGain, Float frequencyHertz) {
        this.index = index;
        this.powered = (packed & 1) == 1;
        this.ptt = (packed & 2) == 2;
        this.gain = gain.floatValue();
        this.micGain = micGain.floatValue();
        this.frequencyHertz = frequencyHertz.floatValue();
    }

    public float getFrequencyHertz() {
        return this.frequencyHertz;
    }

    public int getIndex() {
        return this.index;
    }

    private Byte packBools() {
        return (byte)((this.powered ? 1 : 0) + (this.ptt ? 2 : 0));
    }

    private float getGain() {
        return this.gain;
    }

    private float getMicGain() {
        return this.micGain;
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            ItemStack stack = context.player().getInventory().getItem(this.index);
            if (stack == null) {
                Radiocraft.LOGGER.error("Handheld Radio stack is null for player {} despite getting handheld radio update packet", (Object)context.player().getName());
                return;
            }
            IVHFHandheldCapability cap = (IVHFHandheldCapability)stack.getCapability(RadiocraftCapabilities.VHF_HANDHELDS);
            if (cap == null) {
                Radiocraft.LOGGER.error("held item does not have handheld radio capability yet the following player send handheld radio update packet: {}", (Object)context.player().getName());
                return;
            }
            cap.setPowered(this.powered);
            cap.setPTTDown(this.ptt);
            cap.setGain(this.gain);
            cap.setMicGain(this.micGain);
            cap.setFrequencyHertz(this.frequencyHertz);
        });
    }

    public static void updateServer(int inventoryIndex, IVHFHandheldCapability cap) {
        PacketDistributor.sendToServer((CustomPacketPayload)new SHandheldRadioUpdatePacket(inventoryIndex, cap.isPowered(), cap.isPTTDown(), cap.getGain(), cap.getMicGain(), cap.getFrequencyHertz()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

