/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.radio;

import com.arrl.radiocraft.Radiocraft;
import com.arrl.radiocraft.common.radio.IVoiceReceiver;
import com.arrl.radiocraft.common.radio.antenna.AntennaVoicePacket;
import com.arrl.radiocraft.common.radio.voice.RadiocraftVoicePlugin;
import de.maxhenkel.voicechat.api.ServerLevel;
import de.maxhenkel.voicechat.api.audiochannel.LocationalAudioChannel;
import java.util.UUID;

public class BEVoiceReceiver
implements IVoiceReceiver {
    private LocationalAudioChannel receiveChannel = null;
    private final int x;
    private final int y;
    private final int z;
    private boolean isReceiving;

    public BEVoiceReceiver(int x, int y, int z) {
        this(x, y, z, false);
    }

    public BEVoiceReceiver(int x, int y, int z, boolean isReceiving) {
        this.isReceiving = isReceiving;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void openChannel(ServerLevel level) {
        if (RadiocraftVoicePlugin.API == null) {
            Radiocraft.LOGGER.error("Radiocraft VoiceChatServerApi is null.");
        }
        this.receiveChannel = RadiocraftVoicePlugin.API.createLocationalAudioChannel(UUID.randomUUID(), level, RadiocraftVoicePlugin.API.createPosition((double)this.x, (double)this.y, (double)this.z));
    }

    @Override
    public void receive(AntennaVoicePacket antennaPacket) {
        if (this.isReceiving) {
            if (this.receiveChannel == null) {
                this.openChannel(RadiocraftVoicePlugin.API.fromServerLevel((Object)antennaPacket.getLevel()));
            }
            short[] rawAudio = antennaPacket.getRawAudio();
            for (int i = 0; i < rawAudio.length; ++i) {
                rawAudio[i] = (short)Math.round((double)rawAudio[i] * antennaPacket.getStrength());
            }
            byte[] opusAudio = RadiocraftVoicePlugin.encodingManager.getOrCreate(antennaPacket.getSourcePlayer()).getEncoder().encode(rawAudio);
            this.receiveChannel.send(opusAudio);
        }
    }

    @Override
    public boolean isReceiving() {
        return this.isReceiving;
    }

    @Override
    public void setReceiving(boolean value) {
        this.isReceiving = value;
    }
}

