/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.radio;

import com.arrl.radiocraft.Radiocraft;
import com.arrl.radiocraft.RadiocraftServerConfig;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public record Band(String name, int losRange, int minSkipDay, int maxSkipDay, int minSkipNight, int maxSkipNight, float minFrequency, float maxFrequency) {
    public static Band getBand(int wavelength) {
        RadiocraftServerConfig.BandConfig bandConfig = RadiocraftServerConfig.BAND_CONFIGS.get(wavelength + "m");
        if (bandConfig == null) {
            return null;
        }
        return bandConfig.getBand();
    }

    public static Band getBand(float frequencyHertz) {
        try {
            List<Map.Entry> list = RadiocraftServerConfig.BAND_CONFIGS.entrySet().stream().filter(entry -> ((RadiocraftServerConfig.BandConfig)entry.getValue()).getBand().minFrequency() <= frequencyHertz && frequencyHertz <= ((RadiocraftServerConfig.BandConfig)entry.getValue()).getBand().maxFrequency()).toList();
            return ((RadiocraftServerConfig.BandConfig)list.getFirst().getValue()).getBand();
        }
        catch (Exception e) {
            Radiocraft.LOGGER.error("Frequency {} not found in band config", (Object)Float.valueOf(frequencyHertz));
            return null;
        }
    }

    public static Band getBand(String name) {
        RadiocraftServerConfig.BandConfig bandConfig = RadiocraftServerConfig.BAND_CONFIGS.get(name);
        if (bandConfig == null) {
            return null;
        }
        return bandConfig.getBand();
    }

    public static Collection<Band> getDefaults() {
        return List.of(new Band("2m", 500, 0, 0, 0, 0, 1.44E8f, 1.48E8f), new Band("10m", 800, 0, 0, 0, 0, 2.8E7f, 2.97E7f), new Band("20m", 300, 2000, 6000, 800, 1000, 1.4E7f, 1.435E7f), new Band("40m", 900, 1000, 1100, 100, 3000, 7300000.0f, 9000000.0f), new Band("80m", 600, 700, 800, 600, 2000, 3500000.0f, 4000000.0f));
    }
}

