/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.radio;

import com.arrl.radiocraft.common.radio.Band;

public class BandUtils {
    public static double getBaseStrength(Band band, double distance, double losEfficiency, double skipEfficiency, boolean isDay) {
        double maxSkip;
        if (band == null) {
            return 0.0;
        }
        int los = band.losRange();
        if (distance < (double)los) {
            return (1.0 - distance / (double)los) * losEfficiency;
        }
        double minSkip = isDay ? (double)band.minSkipDay() : (double)band.minSkipNight();
        double d = maxSkip = isDay ? (double)band.maxSkipDay() : (double)band.maxSkipNight();
        if (distance > minSkip && distance < maxSkip) {
            double skipRadius = (maxSkip - minSkip) / 2.0;
            double skipMid = minSkip + skipRadius;
            double distFromMid = Math.abs(distance - skipMid);
            return (1.0 - distFromMid / skipRadius) * skipEfficiency;
        }
        return 0.0;
    }

    public static double getWavelengthMetersFromFrequencyHertz(double frequencyHertz) {
        double SPEED_OF_LIGHT_METERS_PER_SECOND = 2.99792458E8;
        return 2.99792458E8 / frequencyHertz;
    }

    public static boolean areFrequenciesEqualWithTolerance(float a, float b, float tolerance) {
        return Math.abs(a - b) < tolerance;
    }
}

