/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.radio.antenna;

import com.arrl.radiocraft.api.antenna.IAntenna;
import com.arrl.radiocraft.api.antenna.IAntennaType;
import com.arrl.radiocraft.api.capabilities.IBENetworks;
import com.arrl.radiocraft.common.be_networks.network_objects.AntennaNetworkObject;
import com.arrl.radiocraft.common.radio.Band;
import com.arrl.radiocraft.common.radio.SWRHelper;
import com.arrl.radiocraft.common.radio.antenna.AntennaCWPacket;
import com.arrl.radiocraft.common.radio.antenna.AntennaData;
import com.arrl.radiocraft.common.radio.antenna.AntennaNetwork;
import com.arrl.radiocraft.common.radio.antenna.AntennaVoicePacket;
import com.arrl.radiocraft.common.radio.morse.CWBuffer;
import de.maxhenkel.voicechat.api.ServerLevel;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.UnknownNullability;

public class StaticAntenna<T extends AntennaData>
implements IAntenna,
INBTSerializable<CompoundTag> {
    public final IAntennaType<T> type;
    public final T data;
    public final AtomicReference<IAntenna.AntennaPos> pos = new AtomicReference();
    public final Level level;
    private AntennaNetwork network = null;

    public StaticAntenna(IAntennaType<T> type, BlockPos pos, Level level, T data) {
        this.type = type;
        this.data = data;
        this.pos.set(new IAntenna.AntennaPos(pos, level));
        this.level = level;
    }

    public StaticAntenna(IAntennaType<T> type, BlockPos pos, Level level) {
        this.type = type;
        this.data = type.getDefaultData();
        this.pos.set(new IAntenna.AntennaPos(pos, level));
        this.level = level;
    }

    @Override
    public void transmitAudioPacket(ServerLevel level, short[] rawAudio, Band band, float frequencyHertz, UUID sourcePlayer) {
        if (this.network != null) {
            Set<IAntenna> antennas = this.network.allAntennas();
            for (IAntenna antenna : antennas) {
                if (antenna == this) continue;
                AntennaVoicePacket packet = new AntennaVoicePacket(level, (short[])rawAudio.clone(), band, frequencyHertz, 1.0, this, sourcePlayer);
                IAntenna.AntennaPos destination = antenna.getAntennaPos();
                if (destination == null) continue;
                packet.setStrength(this.type.getTransmitEfficiency(packet, this.data, destination.position(), false) * SWRHelper.getEfficiencyMultiplier(this.getSWR(frequencyHertz)));
                antenna.receiveAudioPacket(packet);
            }
        }
    }

    @Override
    public void receiveAudioPacket(AntennaVoicePacket packet) {
        AntennaNetworkObject obj = this.getNetworkObj();
        if (obj != null) {
            packet.setStrength(this.type.getReceiveEfficiency(packet, this.data, this.pos.get().position()));
            obj.receiveAudioPacket(packet);
        }
    }

    @Override
    public void transmitCWPacket(net.minecraft.server.level.ServerLevel level, Collection<CWBuffer> buffers, Band band, float frequencyHertz) {
        if (this.network != null) {
            Set<IAntenna> antennas = this.network.allAntennas();
            for (IAntenna antenna : antennas) {
                if (antenna == this) continue;
                AntennaCWPacket packet = new AntennaCWPacket(level, buffers, band, frequencyHertz, 1.0, this);
                IAntenna.AntennaPos destination = antenna.getAntennaPos();
                if (destination == null) continue;
                packet.setStrength(this.type.getTransmitEfficiency(packet, this.data, destination.position(), true));
                antenna.receiveCWPacket(packet);
            }
        }
    }

    @Override
    public void receiveCWPacket(AntennaCWPacket packet) {
        AntennaNetworkObject obj = this.getNetworkObj();
        if (obj != null) {
            packet.setStrength(this.type.getReceiveEfficiency(packet, this.data, this.pos.get().position()));
            obj.receiveCWPacket(packet);
        }
    }

    public AntennaNetworkObject getNetworkObj() {
        IAntenna.AntennaPos p = this.getAntennaPos();
        return (AntennaNetworkObject)IBENetworks.getObject(p.level(), p.position());
    }

    @Override
    public IAntenna.AntennaPos getAntennaPos() {
        return this.pos.get();
    }

    @Override
    public IAntennaType<? extends AntennaData> getType() {
        return this.type;
    }

    @Override
    public AntennaData getData() {
        return this.data;
    }

    public void setNetwork(AntennaNetwork network) {
        if (this.network != null) {
            this.network.removeAntenna(this);
        }
        network.addAntenna(this);
        this.network = network;
    }

    public double getSWR(float frequencyHertz) {
        return this.type.getSWR(this.data, frequencyHertz);
    }

    public @UnknownNullability CompoundTag serializeNBT(HolderLookup.Provider provider) {
        return (CompoundTag)this.data.serializeNBT(provider);
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.data.deserializeNBT(provider, (Tag)nbt);
    }

    @Override
    public Player getPlayer() {
        return null;
    }
}

