/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.radio.antenna.types;

import com.arrl.radiocraft.Radiocraft;
import com.arrl.radiocraft.common.entities.AntennaWire;
import com.arrl.radiocraft.common.entities.IAntennaWire;
import com.arrl.radiocraft.common.init.RadiocraftBlocks;
import com.arrl.radiocraft.common.radio.BandUtils;
import com.arrl.radiocraft.common.radio.antenna.StaticAntenna;
import com.arrl.radiocraft.common.radio.antenna.types.NonDirectionalAntennaType;
import com.arrl.radiocraft.common.radio.antenna.types.data.DipoleAntennaData;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class DipoleAntennaType
extends NonDirectionalAntennaType<DipoleAntennaData> {
    public DipoleAntennaType() {
        super(Radiocraft.id("dipole"), 0.0, 0.0, 1.0, 1.0);
    }

    @Override
    public StaticAntenna<DipoleAntennaData> match(Level level, BlockPos pos) {
        Vec3 directionArm2;
        if (level.getBlockState(pos).getBlock() != RadiocraftBlocks.BALUN_ONE_TO_ONE.get()) {
            return null;
        }
        List<IAntennaWire> connections = AntennaWire.getWires(level, pos);
        if (connections.size() != 2) {
            return null;
        }
        BlockPos arm1 = connections.get(0).getEndPos();
        BlockPos arm2 = connections.get(1).getEndPos();
        if (arm1.getY() != pos.getY() || arm2.getY() != pos.getY()) {
            return null;
        }
        if (AntennaWire.getWires(level, arm1).size() > 1 || AntennaWire.getWires(level, arm2).size() > 1) {
            return null;
        }
        BlockPos relativeArm1BlockPos = arm1.subtract((Vec3i)pos);
        BlockPos relativeArm2BlockPos = arm2.subtract((Vec3i)pos);
        Vec3 relativeArm1 = new Vec3((double)relativeArm1BlockPos.getX(), (double)relativeArm1BlockPos.getY(), (double)relativeArm1BlockPos.getZ());
        Vec3 relativeArm2 = new Vec3((double)relativeArm2BlockPos.getX(), (double)relativeArm2BlockPos.getY(), (double)relativeArm2BlockPos.getZ());
        Vec3 directionArm1 = new Vec3(relativeArm1.x, 0.0, relativeArm1.z).normalize();
        double dot = directionArm1.dot(directionArm2 = new Vec3(relativeArm2.x, 0.0, relativeArm2.z).normalize());
        if (dot > -0.833) {
            return null;
        }
        return new StaticAntenna<DipoleAntennaData>(this, pos, level, new DipoleAntennaData(relativeArm1.length(), relativeArm2.length()));
    }

    @Override
    public double getSWR(DipoleAntennaData data, float frequencyHertz) {
        int desiredLength = (int)Math.round(BandUtils.getWavelengthMetersFromFrequencyHertz(frequencyHertz) / 4.0);
        double incorrectBlocks = Math.abs((double)desiredLength - data.getArmLength1()) + Math.abs((double)desiredLength - data.getArmLength2());
        return 1.0 + 0.5 * incorrectBlocks;
    }

    @Override
    public DipoleAntennaData getDefaultData() {
        return new DipoleAntennaData(0.0, 0.0);
    }
}

