/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.radio.antenna.types;

import com.arrl.radiocraft.Radiocraft;
import com.arrl.radiocraft.common.entities.AntennaWire;
import com.arrl.radiocraft.common.entities.IAntennaWire;
import com.arrl.radiocraft.common.init.RadiocraftBlocks;
import com.arrl.radiocraft.common.radio.BandUtils;
import com.arrl.radiocraft.common.radio.antenna.StaticAntenna;
import com.arrl.radiocraft.common.radio.antenna.types.NonDirectionalAntennaType;
import com.arrl.radiocraft.common.radio.antenna.types.data.EndFedAntennaData;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EndFedAntennaType
extends NonDirectionalAntennaType<EndFedAntennaData> {
    public EndFedAntennaType() {
        super(Radiocraft.id("end_fed"), -1.25, -1.25, 1.0, 1.0);
    }

    @Override
    public StaticAntenna<EndFedAntennaData> match(Level level, BlockPos pos) {
        if (level.getBlockState(pos).getBlock() != RadiocraftBlocks.BALUN_ONE_TO_ONE.get()) {
            return null;
        }
        List<IAntennaWire> connections = AntennaWire.getWires(level, pos);
        if (connections.size() != 1) {
            return null;
        }
        BlockPos end = connections.get(0).getEndPos();
        if (end.getY() != pos.getY()) {
            return null;
        }
        if (AntennaWire.getWires(level, end).size() > 1) {
            return null;
        }
        BlockPos relativeBlockPos = end.subtract((Vec3i)pos);
        Vec3 relative = new Vec3((double)relativeBlockPos.getX(), (double)relativeBlockPos.getY(), (double)relativeBlockPos.getZ());
        return new StaticAntenna<EndFedAntennaData>(this, pos, level, new EndFedAntennaData(relative.length()));
    }

    @Override
    public double getSWR(EndFedAntennaData data, float frequencyHertz) {
        int desiredLength = (int)Math.round(BandUtils.getWavelengthMetersFromFrequencyHertz(frequencyHertz) / 4.0);
        double incorrectBlocks = Math.abs((double)desiredLength - data.getLength());
        return 1.0 + 0.5 * incorrectBlocks;
    }

    @Override
    public EndFedAntennaData getDefaultData() {
        return new EndFedAntennaData(0.0);
    }
}

