/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.radio.antenna.types;

import com.arrl.radiocraft.Radiocraft;
import com.arrl.radiocraft.common.entities.AntennaWire;
import com.arrl.radiocraft.common.entities.IAntennaWire;
import com.arrl.radiocraft.common.init.RadiocraftBlocks;
import com.arrl.radiocraft.common.radio.BandUtils;
import com.arrl.radiocraft.common.radio.antenna.StaticAntenna;
import com.arrl.radiocraft.common.radio.antenna.types.NonDirectionalAntennaType;
import com.arrl.radiocraft.common.radio.antenna.types.data.HorizontalQuadLoopAntennaData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;

public class HorizontalQuadLoopAntennaType
extends NonDirectionalAntennaType<HorizontalQuadLoopAntennaData> {
    public HorizontalQuadLoopAntennaType() {
        super(Radiocraft.id("horizontal_quad_loop"), 0.0, 0.0, 0.25, 1.25);
    }

    @Override
    public StaticAntenna<HorizontalQuadLoopAntennaData> match(Level level, BlockPos pos) {
        if (level.getBlockState(pos).getBlock() != RadiocraftBlocks.BALUN_TWO_TO_ONE.get()) {
            return null;
        }
        List<IAntennaWire> startConnections = AntennaWire.getWires(level, pos);
        if (startConnections.size() != 2) {
            return null;
        }
        ArrayList<BlockPos> squarePoints = new ArrayList<BlockPos>();
        ArrayList<IAntennaWire> squareWires = new ArrayList<IAntennaWire>();
        IAntennaWire currentWire = startConnections.get(0);
        squarePoints.add(pos);
        squareWires.add(currentWire);
        for (int i = 0; i < 3; ++i) {
            BlockPos end = currentWire.getEndPos();
            if (end.getY() != pos.getY()) {
                return null;
            }
            List<IAntennaWire> connections = AntennaWire.getWires(level, end);
            if (connections.size() != 2) {
                return null;
            }
            currentWire = connections.get(0).isPairedWith(currentWire) ? connections.get(1) : connections.get(0);
            squarePoints.add(end);
            squareWires.add(currentWire);
        }
        if (!((IAntennaWire)squareWires.get(3)).getEndPos().equals(squarePoints.get(0))) {
            return null;
        }
        if (!this.isSquare(squarePoints)) {
            return null;
        }
        int sideLength = (int)Math.sqrt(Math.round(((BlockPos)squarePoints.get(0)).distSqr((Vec3i)squarePoints.get(1))));
        return new StaticAntenna<HorizontalQuadLoopAntennaData>(this, pos, level, new HorizontalQuadLoopAntennaData(sideLength));
    }

    public boolean isSquare(List<BlockPos> points) {
        if (points.size() != 4) {
            return false;
        }
        BlockPos p1 = points.get(0);
        BlockPos p2 = points.get(1);
        BlockPos p4 = points.get(3);
        double d2 = p1.distSqr((Vec3i)p2);
        return d2 == p1.distSqr((Vec3i)p4) && 2.0 * d2 == p1.distSqr((Vec3i)points.get(2)) && 2.0 * d2 == p2.distSqr((Vec3i)p4);
    }

    @Override
    public double getSWR(HorizontalQuadLoopAntennaData data, float frequencyHertz) {
        int desiredLength = (int)Math.round(BandUtils.getWavelengthMetersFromFrequencyHertz(frequencyHertz) / 4.0);
        int incorrectBlocks = Math.abs(desiredLength - data.getSideLength());
        return 1.0 + 0.5 * (double)incorrectBlocks;
    }

    @Override
    public HorizontalQuadLoopAntennaData getDefaultData() {
        return new HorizontalQuadLoopAntennaData(0);
    }
}

