/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.radio.antenna.types;

import com.arrl.radiocraft.api.antenna.IAntennaPacket;
import com.arrl.radiocraft.api.antenna.IAntennaType;
import com.arrl.radiocraft.common.radio.BandUtils;
import com.arrl.radiocraft.common.radio.antenna.AntennaData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;

public abstract class NonDirectionalAntennaType<T extends AntennaData>
implements IAntennaType<T> {
    private static final double CW_RANGE_MULTIPLIER = 1.5;
    private final ResourceLocation id;
    private final double los;
    private final double skip;
    private final double receiveGainDbi;
    private final double transmitGainDbi;
    private final double receiveGainLinear;
    private final double transmitGainLinear;

    protected NonDirectionalAntennaType(ResourceLocation id, double receiveGainDbi, double transmitGainDbi, double los, double skip) {
        this.id = id;
        this.los = los;
        this.skip = skip;
        this.receiveGainDbi = receiveGainDbi;
        this.transmitGainDbi = transmitGainDbi;
        this.receiveGainLinear = NonDirectionalAntennaType.dbiToLinear(receiveGainDbi);
        this.transmitGainLinear = NonDirectionalAntennaType.dbiToLinear(transmitGainDbi);
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public double getTransmitEfficiency(IAntennaPacket packet, T data, BlockPos destination, boolean isCW) {
        double distance = this.computeDistance(packet, destination);
        double adjustedDistance = this.modifyDistanceForTransmit(packet, data, destination, distance);
        double propagation = this.getPropagationStrength(packet, adjustedDistance, isCW);
        return propagation * this.getTransmitGainLinear();
    }

    @Override
    public double getReceiveEfficiency(IAntennaPacket packet, T data, BlockPos pos) {
        return this.getReceiveGainLinear() * packet.getStrength();
    }

    protected double computeDistance(IAntennaPacket packet, BlockPos destination) {
        return Math.sqrt(packet.getSource().getAntennaPos().position().distSqr((Vec3i)destination));
    }

    protected double modifyDistanceForTransmit(IAntennaPacket packet, T data, BlockPos destination, double distance) {
        return distance;
    }

    protected double getPropagationStrength(IAntennaPacket packet, double distance, boolean isCW) {
        double effectiveDistance = isCW ? distance / 1.5 : distance;
        return BandUtils.getBaseStrength(packet.getBand(), effectiveDistance, this.getLosEfficiency(), this.getSkipEfficiency(), packet.getLevel().isDay());
    }

    protected double getLosEfficiency() {
        return this.los;
    }

    protected double getSkipEfficiency() {
        return this.skip;
    }

    public double getReceiveGainDbi() {
        return this.receiveGainDbi;
    }

    public double getTransmitGainDbi() {
        return this.transmitGainDbi;
    }

    public double getReceiveGainLinear() {
        return this.receiveGainLinear;
    }

    public double getTransmitGainLinear() {
        return this.transmitGainLinear;
    }

    private static double dbiToLinear(double dbi) {
        return Math.pow(10.0, dbi / 10.0);
    }
}

