/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.radio.antenna.types;

import com.arrl.radiocraft.Radiocraft;
import com.arrl.radiocraft.common.entities.AntennaWire;
import com.arrl.radiocraft.common.init.RadiocraftBlocks;
import com.arrl.radiocraft.common.radio.BandUtils;
import com.arrl.radiocraft.common.radio.antenna.StaticAntenna;
import com.arrl.radiocraft.common.radio.antenna.types.NonDirectionalAntennaType;
import com.arrl.radiocraft.common.radio.antenna.types.data.QuarterWaveVerticalAntennaData;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;

public class QuarterWaveVerticalAntennaType
extends NonDirectionalAntennaType<QuarterWaveVerticalAntennaData> {
    public QuarterWaveVerticalAntennaType() {
        super(Radiocraft.id("quarter_wave_vertical"), 0.0, 0.0, 1.2, 0.7);
    }

    @Override
    public StaticAntenna<QuarterWaveVerticalAntennaData> match(Level level, BlockPos pos) {
        if (level.getBlockState(pos).getBlock() != RadiocraftBlocks.BALUN_ONE_TO_ONE.get()) {
            return null;
        }
        if (!AntennaWire.getWires(level, pos).isEmpty()) {
            return null;
        }
        int height = this.getHeight(level, pos);
        if (height == 0) {
            return null;
        }
        return new StaticAntenna<QuarterWaveVerticalAntennaData>(this, pos, level, new QuarterWaveVerticalAntennaData(height));
    }

    public int getHeight(Level level, BlockPos pos) {
        BlockPos.MutableBlockPos _pos = pos.mutable();
        int poles = 0;
        boolean stop = false;
        while (!stop) {
            _pos.setY(_pos.getY() + 1);
            if (level.getBlockState((BlockPos)_pos).getBlock() == RadiocraftBlocks.ANTENNA_POLE.get()) {
                ++poles;
                continue;
            }
            stop = true;
        }
        return poles;
    }

    @Override
    public double getSWR(QuarterWaveVerticalAntennaData data, float frequencyHertz) {
        int desiredLength = (int)Math.round(BandUtils.getWavelengthMetersFromFrequencyHertz(frequencyHertz) / 4.0);
        int incorrectBlocks = Math.abs(desiredLength - data.getHeight());
        return incorrectBlocks == 0 ? 1.0 : 10.0;
    }

    @Override
    public QuarterWaveVerticalAntennaData getDefaultData() {
        return new QuarterWaveVerticalAntennaData(0);
    }
}

