/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.radio.antenna.types;

import com.arrl.radiocraft.Radiocraft;
import com.arrl.radiocraft.api.antenna.IAntennaPacket;
import com.arrl.radiocraft.common.init.RadiocraftBlocks;
import com.arrl.radiocraft.common.radio.antenna.StaticAntenna;
import com.arrl.radiocraft.common.radio.antenna.types.NonDirectionalAntennaType;
import com.arrl.radiocraft.common.radio.antenna.types.data.EmptyAntennaData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class WideBandReceiveAntennaType
extends NonDirectionalAntennaType<EmptyAntennaData> {
    protected WideBandReceiveAntennaType(double receiveGainDbi, double transmitGainDbi, double los, double skip) {
        super(Radiocraft.id("wide_band_receive"), receiveGainDbi, transmitGainDbi, los, skip);
    }

    @Override
    public StaticAntenna<EmptyAntennaData> match(Level level, BlockPos pos) {
        if (!level.getBlockState(pos).is((Block)RadiocraftBlocks.ANTENNA_POLE.get())) {
            return null;
        }
        if (!level.getBlockState(pos.above()).is((Block)RadiocraftBlocks.ANTENNA_POLE.get())) {
            return null;
        }
        Direction.Axis first = this.validArm(level, pos.above(2));
        if (first == null) {
            return null;
        }
        Direction.Axis second = this.validArm(level, pos.above(3));
        if (second == null || first == second) {
            return null;
        }
        return new StaticAntenna<EmptyAntennaData>(this, pos, level);
    }

    public Direction.Axis validArm(Level level, BlockPos pos) {
        Direction.Axis axis;
        if (!level.getBlockState(pos).is(Blocks.IRON_BARS)) {
            return null;
        }
        Direction.Axis axis2 = axis = level.getBlockState(pos.offset(-1, 0, 0)).is(Blocks.IRON_BARS) ? Direction.Axis.X : Direction.Axis.Z;
        if (axis == Direction.Axis.X) {
            if (level.getBlockState(pos.offset(0, 0, -1)).is(Blocks.IRON_BARS) || level.getBlockState(pos.offset(0, 0, 1)).is(Blocks.IRON_BARS)) {
                return null;
            }
            if (level.getBlockState(pos.offset(1, 0, 0)).is(Blocks.IRON_BARS)) {
                return Direction.Axis.X;
            }
        } else {
            if (level.getBlockState(pos.offset(1, 0, 0)).is(Blocks.IRON_BARS)) {
                return null;
            }
            if (level.getBlockState(pos.offset(0, 0, -1)).is(Blocks.IRON_BARS) || level.getBlockState(pos.offset(0, 0, 1)).is(Blocks.IRON_BARS)) {
                return Direction.Axis.Z;
            }
        }
        return null;
    }

    @Override
    public double getTransmitEfficiency(IAntennaPacket packet, EmptyAntennaData data, BlockPos destination, boolean isCW) {
        return 0.0;
    }

    @Override
    public double getReceiveEfficiency(IAntennaPacket packet, EmptyAntennaData data, BlockPos pos) {
        double f = switch (packet.getBand().name()) {
            case "2m" -> 0.7;
            case "10m" -> 0.5;
            case "20m" -> 0.3;
            case "40m", "80m" -> 0.2;
            default -> 0.0;
        };
        return this.getReceiveGainLinear() * packet.getStrength() * f;
    }

    @Override
    public double getSWR(EmptyAntennaData data, float frequencyHertz) {
        return 1.0;
    }

    @Override
    public EmptyAntennaData getDefaultData() {
        return new EmptyAntennaData();
    }
}

