/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.radio.antenna.types.vhf;

import com.arrl.radiocraft.Radiocraft;
import com.arrl.radiocraft.api.antenna.IAntennaPacket;
import com.arrl.radiocraft.common.init.RadiocraftBlocks;
import com.arrl.radiocraft.common.radio.Band;
import com.arrl.radiocraft.common.radio.antenna.StaticAntenna;
import com.arrl.radiocraft.common.radio.antenna.types.DirectionalAntennaType;
import com.arrl.radiocraft.common.radio.antenna.types.data.YagiAntennaData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec2;

public class YagiAntennaType
extends DirectionalAntennaType<YagiAntennaData> {
    public YagiAntennaType() {
        super(Radiocraft.id("yagi"), 0.0, 0.0, 1.0, 0.0);
    }

    @Override
    public StaticAntenna<YagiAntennaData> match(Level level, BlockPos pos) {
        return level.getBlockState(pos).is((Block)RadiocraftBlocks.YAGI_ANTENNA.get()) ? new StaticAntenna<YagiAntennaData>(this, pos, level) : null;
    }

    @Override
    public double getDirectionalEfficiency(YagiAntennaData data, BlockPos from, BlockPos to) {
        BlockPos offset = to.subtract((Vec3i)from);
        Vec2 dir = new Vec2((float)offset.getX(), (float)offset.getZ()).normalized();
        Vec3i normal = data.getFacing().getNormal();
        double f = -(((double)new Vec2((float)normal.getX(), (float)normal.getZ()).dot(dir) - 1.0) / 2.0);
        if (f < 0.25) {
            return Mth.lerp((double)(f / 0.25), (double)1.0, (double)0.1);
        }
        return f * 0.1;
    }

    @Override
    protected double modifyDistanceForTransmit(IAntennaPacket packet, YagiAntennaData data, BlockPos destination, double distance) {
        return distance / 2.0;
    }

    @Override
    public double getSWR(YagiAntennaData data, float frequencyHertz) {
        return Band.getBand(frequencyHertz) == Band.getBand("2m") ? 1.0 : 10.0;
    }

    @Override
    public YagiAntennaData getDefaultData() {
        return new YagiAntennaData(Direction.NORTH);
    }
}

