/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.radio.morse;

import com.arrl.radiocraft.common.radio.morse.CWBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class CWReceiveBuffer {
    private final List<PlaybackEntry> playbackBuffer = new ArrayList<PlaybackEntry>();

    public void addToBuffer(CWBuffer buffer, float strength) {
        if (this.playbackBuffer.isEmpty()) {
            this.playbackBuffer.add(new PlaybackEntry(buffer, strength));
        } else {
            for (int i = 0; i < this.playbackBuffer.size(); ++i) {
                if (this.playbackBuffer.get((int)i).buffer.getId() > buffer.getId()) {
                    this.playbackBuffer.add(i, new PlaybackEntry(buffer, strength));
                    return;
                }
                if (i != this.playbackBuffer.size() - 1) continue;
                this.playbackBuffer.add(new PlaybackEntry(buffer, strength));
                return;
            }
        }
    }

    public float getNextStrength() {
        if (!this.playbackBuffer.isEmpty()) {
            PlaybackEntry entry = this.playbackBuffer.get(0);
            boolean f = entry.buffer.readNext();
            if (entry.buffer.isFinished()) {
                this.playbackBuffer.remove(entry);
            }
            if (f) {
                return entry.strength;
            }
        }
        return 0.0f;
    }

    public record PlaybackEntry(@Nonnull CWBuffer buffer, float strength) {
    }
}

