/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.radio.solar;

import com.arrl.radiocraft.Radiocraft;

public class SolarEvent {
    private final float noise;
    private final int minDuration;
    private final int maxDuration;

    public SolarEvent(float noise, int minDuration, int maxDuration) {
        this.noise = noise;
        this.minDuration = minDuration;
        this.maxDuration = maxDuration;
    }

    public float getNoise() {
        return this.noise;
    }

    public SolarEventInstance getInstance() {
        return new SolarEventInstance(this, Radiocraft.RANDOM.nextInt(this.minDuration, this.maxDuration + 1));
    }

    public static class SolarEventInstance {
        private final SolarEvent event;
        private final int duration;
        private int ticks;

        protected SolarEventInstance(SolarEvent event, int duration) {
            this.event = event;
            this.duration = duration;
        }

        public SolarEvent getEvent() {
            return this.event;
        }

        public int getDuration() {
            return this.duration;
        }

        public int getTicks() {
            return this.ticks;
        }

        public void tick() {
            ++this.ticks;
        }

        public boolean isFinished() {
            return this.ticks >= this.getDuration();
        }
    }
}

