/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.radio.solar;

import com.arrl.radiocraft.Radiocraft;
import com.arrl.radiocraft.common.init.RadiocraftData;
import com.arrl.radiocraft.common.radio.solar.SolarEvent;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

@EventBusSubscriber(modid="radiocraft")
public class SolarEventManager {
    private static Map<ResourceKey<Level>, SolarEvent.SolarEventInstance> currentEvents = new HashMap<ResourceKey<Level>, SolarEvent.SolarEventInstance>();

    public static void setEvent(ResourceKey<Level> dimension, SolarEvent.SolarEventInstance event) {
        currentEvents.put(dimension, event);
    }

    public static void setEvent(Level level, SolarEvent.SolarEventInstance event) {
        SolarEventManager.setEvent((ResourceKey<Level>)level.dimension(), event);
    }

    public static SolarEvent.SolarEventInstance getEvent(Level level) {
        return SolarEventManager.getEvent((ResourceKey<Level>)level.dimension());
    }

    public static SolarEvent.SolarEventInstance getEvent(ResourceKey<Level> dimension) {
        return currentEvents.get(dimension);
    }

    @SubscribeEvent
    public static void tick(LevelTickEvent.Pre event) {
        if (!event.getLevel().isClientSide) {
            SolarEvent.SolarEventInstance solarEvent = SolarEventManager.getEvent(event.getLevel());
            if (solarEvent == null || solarEvent.isFinished()) {
                solarEvent = RadiocraftData.SOLAR_EVENTS.getWeightedRandom().getInstance();
                SolarEventManager.setEvent(event.getLevel(), solarEvent);
                Radiocraft.LOGGER.info("Dimension: {} Solar Event Noise: {}", (Object)event.getLevel().dimension(), (Object)Float.valueOf(solarEvent.getEvent().getNoise()));
            }
            solarEvent.tick();
        }
    }

    @SubscribeEvent
    public static void playerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
        }
    }

    @SubscribeEvent
    public static void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
        }
    }
}

