/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.radio.solar;

import com.arrl.radiocraft.Radiocraft;
import com.arrl.radiocraft.common.radio.solar.SolarEvent;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.antlr.v4.runtime.misc.Pair;

public class SolarEventReloadListener
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new Gson();
    private final Map<ResourceLocation, Pair<SolarEvent, Integer>> events = new HashMap<ResourceLocation, Pair<SolarEvent, Integer>>();
    private int totalWeight = 0;

    public SolarEventReloadListener(String directory) {
        super(GSON, directory);
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsonMap, ResourceManager resourceManager, ProfilerFiller profiler) {
        this.events.clear();
        jsonMap.forEach((resourceLocation, jsonElement) -> {
            try {
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                float noise = jsonObject.get("noise").getAsFloat();
                int minDuration = jsonObject.get("minDuration").getAsInt();
                int maxDuration = jsonObject.get("maxDuration").getAsInt();
                int weight = jsonObject.get("weight").getAsInt();
                this.events.put((ResourceLocation)resourceLocation, (Pair<SolarEvent, Integer>)new Pair((Object)new SolarEvent(noise, minDuration, maxDuration), (Object)weight));
                this.totalWeight += weight;
            }
            catch (JsonParseException | IllegalArgumentException jsonparseexception) {
                Radiocraft.LOGGER.error("Parsing error loading solar event {}: {}", resourceLocation, (Object)jsonparseexception.getMessage());
            }
        });
    }

    public ResourceLocation getKey(SolarEvent event) {
        for (ResourceLocation key : this.events.keySet()) {
            if (this.events.get((Object)key).a != event) continue;
            return key;
        }
        return null;
    }

    public SolarEvent getValue(ResourceLocation key) {
        return (SolarEvent)this.events.get((Object)key).a;
    }

    public SolarEvent getWeightedRandom() {
        int r = (int)(Math.random() * (double)this.totalWeight);
        for (Pair<SolarEvent, Integer> entry : this.events.values()) {
            if ((r -= ((Integer)entry.b).intValue()) > 0) continue;
            return (SolarEvent)entry.a;
        }
        Radiocraft.LOGGER.error("No solar events found, using default");
        return new SolarEvent(0.3f, 1, 1);
    }
}

