/*
 * Decompiled with CFR 0.152.
 */
package com.arrl.radiocraft.common.radio.voice;

import com.arrl.radiocraft.common.radio.voice.RadiocraftVoicePlugin;
import de.maxhenkel.voicechat.api.opus.OpusDecoder;
import de.maxhenkel.voicechat.api.opus.OpusEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class EncodingManager {
    private final Map<UUID, EncodingData> encodingData = new HashMap<UUID, EncodingData>();

    public EncodingData getOrCreate(UUID player) {
        if (!this.encodingData.containsKey(player)) {
            this.encodingData.put(player, new EncodingData());
        }
        return this.encodingData.get(player);
    }

    public void close(UUID player) {
        if (this.encodingData.containsKey(player)) {
            this.encodingData.get(player).close();
            this.encodingData.remove(player);
        }
    }

    public static class EncodingData {
        private final OpusEncoder encoder;
        private final OpusDecoder decoder;

        public EncodingData() {
            if (RadiocraftVoicePlugin.API == null) {
                throw new IllegalStateException("Tried to create EncodingData object without a valid API");
            }
            this.encoder = RadiocraftVoicePlugin.API.createEncoder();
            this.decoder = RadiocraftVoicePlugin.API.createDecoder();
        }

        public OpusEncoder getEncoder() {
            return this.encoder;
        }

        public OpusDecoder getDecoder() {
            return this.decoder;
        }

        public void close() {
            this.encoder.close();
            this.decoder.close();
        }

        public void reset() {
            this.encoder.resetState();
            this.decoder.resetState();
        }
    }
}

